/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractOnHeapClusteringPrefix;
import org.apache.cassandra.db.BufferClustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractBufferClusteringPrefix
extends AbstractOnHeapClusteringPrefix<ByteBuffer> {
    public static final ByteBuffer[] EMPTY_VALUES_ARRAY = new ByteBuffer[0];

    protected AbstractBufferClusteringPrefix(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public ValueAccessor<ByteBuffer> accessor() {
        return ByteBufferAccessor.instance;
    }

    @Override
    public ByteBuffer[] getBufferArray() {
        return (ByteBuffer[])this.getRawValues();
    }

    @Override
    public ClusteringPrefix<ByteBuffer> minimize() {
        if (!ByteBufferUtil.canMinimize((ByteBuffer[])this.values)) {
            return this;
        }
        return new BufferClustering(ByteBufferUtil.minimizeBuffers((ByteBuffer[])this.values));
    }
}

