/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public class TokenFct
extends NativeScalarFunction {
    private final TableMetadata metadata;

    public TokenFct(TableMetadata metadata) {
        super("token", metadata.partitioner.getTokenValidator(), TokenFct.getKeyTypes(metadata));
        this.metadata = metadata;
    }

    private static AbstractType[] getKeyTypes(TableMetadata metadata) {
        AbstractType[] types = new AbstractType[metadata.partitionKeyColumns().size()];
        int i = 0;
        for (ColumnMetadata def : metadata.partitionKeyColumns()) {
            types[i++] = def.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        CBuilder builder = CBuilder.create(this.metadata.partitionKeyAsClusteringComparator());
        for (int i = 0; i < parameters.size(); ++i) {
            ByteBuffer bb = parameters.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return this.metadata.partitioner.getTokenFactory().toByteArray(this.metadata.partitioner.getToken(builder.build().serializeAsPartitionKey()));
    }
}

