/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusLogger {
    private static final Logger logger = LoggerFactory.getLogger(StatusLogger.class);
    private static final ReentrantLock busyMonitor = new ReentrantLock();

    public static void log() {
        if (busyMonitor.tryLock()) {
            try {
                StatusLogger.logStatus();
            }
            finally {
                busyMonitor.unlock();
            }
        } else {
            logger.trace("StatusLogger is busy");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logStatus() {
        void var1_5;
        logger.info(String.format("%-28s%10s%10s%15s%10s%18s", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All Time Blocked"));
        for (ThreadPoolMetrics threadPoolMetrics : CassandraMetricsRegistry.Metrics.allThreadPoolMetrics()) {
            logger.info(String.format("%-28s%10s%10s%15s%10s%18s", threadPoolMetrics.poolName, threadPoolMetrics.activeTasks.getValue(), threadPoolMetrics.pendingTasks.getValue(), threadPoolMetrics.completedTasks.getValue(), threadPoolMetrics.currentBlocked.getCount(), threadPoolMetrics.totalBlocked.getCount()));
        }
        logger.info(String.format("%-25s%10s%10s", "CompactionManager", CompactionManager.instance.getActiveCompactions(), CompactionManager.instance.getPendingTasks()));
        int pendingLargeMessages = 0;
        for (int n : MessagingService.instance().getLargeMessagePendingTasks().values()) {
            pendingLargeMessages += n;
        }
        boolean bl = false;
        for (int n : MessagingService.instance().getSmallMessagePendingTasks().values()) {
            var1_5 += n;
        }
        logger.info(String.format("%-25s%10s%10s", "MessagingService", "n/a", pendingLargeMessages + "/" + (int)var1_5));
        AutoSavingCache<KeyCacheKey, RowIndexEntry> keyCache = CacheService.instance.keyCache;
        AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache = CacheService.instance.rowCache;
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        logger.info(String.format("%-25s%10s%25s%25s", "Cache Type", "Size", "Capacity", "KeysToSave"));
        logger.info(String.format("%-25s%10s%25s%25s", "KeyCache", keyCache.weightedSize(), keyCache.getCapacity(), keyCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keyCacheKeysToSave)));
        logger.info(String.format("%-25s%10s%25s%25s", "RowCache", rowCache.weightedSize(), rowCache.getCapacity(), rowCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(rowCacheKeysToSave)));
        logger.info(String.format("%-25s%20s", "Table", "Memtable ops,data"));
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            logger.info(String.format("%-25s%20s", cfs.keyspace.getName() + "." + cfs.name, cfs.metric.memtableColumnsCount.getValue() + "," + cfs.metric.memtableLiveDataSize.getValue()));
        }
    }
}

