/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.BasicTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.DurationTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.InetAddressDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.ListTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.MapTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.SetTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimeUUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimestampTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UserDefinedTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.SchemaBuilder;

@ThreadSafe
@Immutable
public final class CassandraTypeDeserializer {
    private Map<Class<? extends AbstractType>, TypeDeserializer> TYPE_MAP;
    private static CassandraTypeDeserializer instance;

    private CassandraTypeDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CassandraTypeDeserializer getInstance() {
        if (instance != null) return instance;
        Class<CassandraTypeDeserializer> clazz = CassandraTypeDeserializer.class;
        synchronized (CassandraTypeDeserializer.class) {
            if (instance != null) return instance;
            instance = new CassandraTypeDeserializer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void init(DebeziumTypeDeserializer typeDeserializer) {
        CassandraTypeDeserializer instance = CassandraTypeDeserializer.getInstance();
        instance.initInternal(typeDeserializer);
    }

    private void initInternal(DebeziumTypeDeserializer deserializer) {
        if (this.TYPE_MAP != null) {
            return;
        }
        HashMap<Class, TypeDeserializer> tmp = new HashMap<Class, TypeDeserializer>();
        tmp.put(BooleanType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.BOOLEAN_TYPE));
        tmp.put(UTF8Type.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.STRING_TYPE));
        tmp.put(AsciiType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.STRING_TYPE));
        tmp.put(ByteType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.BYTE_TYPE));
        tmp.put(BytesType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.BYTES_TYPE));
        tmp.put(FloatType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.FLOAT_TYPE));
        tmp.put(DoubleType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.DOUBLE_TYPE));
        tmp.put(DecimalType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.DOUBLE_TYPE));
        tmp.put(Int32Type.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.INT_TYPE));
        tmp.put(ShortType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.SHORT_TYPE));
        tmp.put(LongType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.LONG_TYPE));
        tmp.put(TimeType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.LONG_TYPE));
        tmp.put(CounterColumnType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.LONG_TYPE));
        tmp.put(SimpleDateType.class, new BasicTypeDeserializer(deserializer, CassandraTypeKafkaSchemaBuilders.DATE_TYPE));
        tmp.put(InetAddressType.class, new InetAddressDeserializer(deserializer));
        tmp.put(TimestampType.class, new TimestampTypeDeserializer(deserializer));
        tmp.put(DurationType.class, new DurationTypeDeserializer(deserializer));
        tmp.put(UUIDType.class, new UUIDTypeDeserializer(deserializer));
        tmp.put(TimeUUIDType.class, new TimeUUIDTypeDeserializer(deserializer));
        tmp.put(ListType.class, new ListTypeDeserializer(deserializer));
        tmp.put(SetType.class, new SetTypeDeserializer(deserializer));
        tmp.put(MapType.class, new MapTypeDeserializer(deserializer));
        tmp.put(TupleType.class, new TupleTypeDeserializer());
        tmp.put(UserType.class, new UserDefinedTypeDeserializer());
        this.TYPE_MAP = Collections.unmodifiableMap(tmp);
    }

    public static Object deserialize(DataType dataType, ByteBuffer bb) {
        AbstractType<?> abstractType = CassandraTypeConverter.convert(dataType);
        return CassandraTypeDeserializer.deserialize(abstractType, bb);
    }

    public static Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        if (abstractType.isReversed()) {
            abstractType = ((ReversedType)abstractType).baseType;
        }
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(abstractType);
        return typeDeserializer.deserialize(abstractType, bb);
    }

    public static Object deserialize(CollectionType<?> collectionType, ComplexColumnData ccd) {
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(collectionType);
        return ((CollectionTypeDeserializer)typeDeserializer).deserialize(collectionType, ccd);
    }

    public static SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(abstractType);
        return typeDeserializer.getSchemaBuilder(abstractType);
    }

    public static TypeDeserializer getTypeDeserializer(AbstractType<?> abstractType) {
        return CassandraTypeDeserializer.getInstance().TYPE_MAP.get(abstractType.getClass());
    }
}

