/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.DebeziumException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.apache.cassandra.db.commitlog.CommitLogPosition;

public class LogicalCommitLog {
    CommitLogPosition commitLogPosition;
    File log;
    File index;
    long commitLogSegmentId;
    int offsetOfEndOfLastWrittenCDCMutation = 0;
    boolean completed = false;

    public LogicalCommitLog(File index) {
        this.index = index;
        this.log = LogicalCommitLog.parseCommitLogName(index);
        this.commitLogSegmentId = LogicalCommitLog.parseSegmentId(this.log);
        this.commitLogPosition = new CommitLogPosition(this.commitLogSegmentId, 0);
    }

    public static File parseCommitLogName(File index) {
        String newFileName = index.toPath().getFileName().toString().replace("_cdc.idx", ".log");
        return index.toPath().getParent().resolve(newFileName).toFile();
    }

    public static long parseSegmentId(File logName) {
        return Long.parseLong(logName.getName().split("-")[2].split("\\.")[0]);
    }

    public boolean exists() {
        return this.log.exists();
    }

    public void parseCommitLogIndex() throws DebeziumException {
        if (!this.index.exists()) {
            return;
        }
        try {
            List<String> lines = Files.readAllLines(this.index.toPath(), StandardCharsets.UTF_8);
            if (lines.isEmpty()) {
                return;
            }
            this.offsetOfEndOfLastWrittenCDCMutation = Integer.parseInt(lines.get(0));
            if (lines.size() == 2) {
                this.completed = "COMPLETED".equals(lines.get(1));
            }
        }
        catch (Exception ex) {
            throw new DebeziumException(String.format("Unable to parse commit log index file %s", this.index.toPath()), (Throwable)ex);
        }
    }

    public String toString() {
        return "LogicalCommitLog{commitLogPosition=" + this.commitLogPosition + ", synced=" + this.offsetOfEndOfLastWrittenCDCMutation + ", completed=" + this.completed + ", log=" + this.log + ", index=" + this.index + ", commitLogSegmentId=" + this.commitLogSegmentId + "}";
    }
}

