/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.management.ManagementFactory;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MBeanWrapper {
    public static final Logger logger = LoggerFactory.getLogger(MBeanWrapper.class);
    public static final MBeanWrapper instance = MBeanWrapper.create();

    public static MBeanWrapper create() {
        if (CassandraRelevantProperties.IS_DISABLED_MBEAN_REGISTRATION.getBoolean()) {
            return new NoOpMBeanWrapper();
        }
        String klass = CassandraRelevantProperties.MBEAN_REGISTRATION_CLASS.getString();
        if (klass == null) {
            return new PlatformMBeanWrapper();
        }
        return (MBeanWrapper)FBUtilities.construct(klass, "mbean");
    }

    public void registerMBean(Object var1, ObjectName var2, OnException var3);

    default public void registerMBean(Object obj, ObjectName mbeanName) {
        this.registerMBean(obj, mbeanName, OnException.THROW);
    }

    default public void registerMBean(Object obj, String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return;
        }
        this.registerMBean(obj, name, onException);
    }

    default public void registerMBean(Object obj, String mbeanName) {
        this.registerMBean(obj, mbeanName, OnException.THROW);
    }

    public boolean isRegistered(ObjectName var1, OnException var2);

    default public boolean isRegistered(ObjectName mbeanName) {
        return this.isRegistered(mbeanName, OnException.THROW);
    }

    default public boolean isRegistered(String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return false;
        }
        return this.isRegistered(name, onException);
    }

    default public boolean isRegistered(String mbeanName) {
        return this.isRegistered(mbeanName, OnException.THROW);
    }

    public void unregisterMBean(ObjectName var1, OnException var2);

    default public void unregisterMBean(ObjectName mbeanName) {
        this.unregisterMBean(mbeanName, OnException.THROW);
    }

    default public void unregisterMBean(String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return;
        }
        this.unregisterMBean(name, onException);
    }

    default public void unregisterMBean(String mbeanName) {
        this.unregisterMBean(mbeanName, OnException.THROW);
    }

    public static ObjectName create(String mbeanName, OnException onException) {
        try {
            return new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            onException.handler.accept(e);
            return null;
        }
    }

    public static enum OnException {
        THROW(e -> {
            throw new RuntimeException((Throwable)e);
        }),
        LOG(e -> logger.error("Error in MBean wrapper: ", (Throwable)e)),
        IGNORE(e -> {});

        public final Consumer<Exception> handler;

        private OnException(Consumer<Exception> handler) {
            this.handler = handler;
        }
    }

    public static class PlatformMBeanWrapper
    implements MBeanWrapper {
        private final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.registerMBean(obj, mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            try {
                return this.mbs.isRegistered(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.unregisterMBean(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }
    }

    public static class NoOpMBeanWrapper
    implements MBeanWrapper {
        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void registerMBean(Object obj, String mbeanName, OnException onException) {
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            return false;
        }

        @Override
        public boolean isRegistered(String mbeanName, OnException onException) {
            return false;
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void unregisterMBean(String mbeanName, OnException onException) {
        }
    }
}

