/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.connector.cassandra.CellData;
import io.debezium.connector.cassandra.KafkaRecord;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class RowData
implements KafkaRecord {
    private final Map<String, CellData> cellMap = new LinkedHashMap<String, CellData>();
    private Object start = null;
    private Object end = null;

    public void addStart(Object start) {
        this.start = start;
    }

    public void addEnd(Object end) {
        this.end = end;
    }

    public Object getStart() {
        return this.start;
    }

    public Object getEnd() {
        return this.end;
    }

    public void addCell(CellData cellData) {
        this.cellMap.put(cellData.name, cellData);
    }

    public void removeCell(String columnName) {
        if (this.hasCell(columnName)) {
            this.cellMap.remove(columnName);
        }
    }

    public boolean hasCell(String columnName) {
        return this.cellMap.containsKey(columnName);
    }

    public boolean hasAnyCell() {
        return !this.cellMap.isEmpty();
    }

    @Override
    public Struct record(Schema schema) {
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            Schema cellSchema = KeyValueSchema.getFieldSchema(field.name(), schema);
            if (field.name().equals(".range_start") && this.start != null) {
                struct.put(field.name(), this.start);
                continue;
            }
            if (field.name().equals(".range_end") && this.end != null) {
                struct.put(field.name(), this.end);
                continue;
            }
            CellData cellData = this.cellMap.get(field.name());
            if (cellData == null) continue;
            struct.put(field.name(), (Object)cellData.record(cellSchema));
        }
        return struct;
    }

    public RowData copy() {
        RowData copy = new RowData();
        for (CellData cellData : this.cellMap.values()) {
            copy.addCell(cellData);
        }
        return copy;
    }

    static Schema rowSchema(TableMetadata tm) {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<DataType> columnTypes = new ArrayList<DataType>();
        for (ColumnMetadata cm : tm.getColumns().values()) {
            columnNames.add(cm.getName().toString());
            columnTypes.add(cm.getType());
        }
        return RowData.rowSchema(columnNames, columnTypes);
    }

    static Schema rowSchema(List<String> columnNames, List<DataType> columnsTypes) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("after");
        for (int i = 0; i < columnNames.size(); ++i) {
            Schema valueSchema = CassandraTypeDeserializer.getSchemaBuilder(CassandraTypeConverter.convert(columnsTypes.get(i))).build();
            String columnName = columnNames.get(i);
            Schema optionalCellSchema = CellData.cellSchema(columnName, valueSchema, true);
            if (optionalCellSchema == null) continue;
            schemaBuilder.field(columnName, optionalCellSchema);
        }
        schemaBuilder.field(".range_start", Schema.OPTIONAL_STRING_SCHEMA);
        schemaBuilder.field(".range_end", Schema.OPTIONAL_STRING_SCHEMA);
        return schemaBuilder.build();
    }

    List<CellData> getPrimary() {
        return this.cellMap.values().stream().filter(CellData::isPrimary).collect(Collectors.toList());
    }

    public String toString() {
        return this.cellMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowData rowData = (RowData)o;
        return Objects.equals(this.cellMap, rowData.cellMap);
    }

    public int hashCode() {
        return Objects.hash(this.cellMap);
    }
}

