/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.AbstractCassandra4CommitLogParser;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogProcessingResult;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.LogicalCommitLog;
import java.util.List;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra4CommitLogBatchParser
extends AbstractCassandra4CommitLogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cassandra4CommitLogBatchParser.class);

    public Cassandra4CommitLogBatchParser(LogicalCommitLog commitLog, List<ChangeEventQueue<Event>> queues, CommitLogProcessorMetrics metrics, CassandraConnectorContext context) {
        super(commitLog, queues, metrics, context);
    }

    @Override
    public CommitLogProcessingResult parse() {
        CommitLogProcessingResult result;
        try {
            this.parseIndexFile(this.commitLog);
            while (!this.commitLog.completed) {
                if (this.completePrematurely) {
                    LOGGER.info("Processing of {} completed prematurely", (Object)this.commitLog);
                    return new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.COMPLETED_PREMATURELY);
                }
                Thread.sleep(this.pollingInterval);
                this.parseIndexFile(this.commitLog);
            }
            LOGGER.info("Starting to read Commit log file: {} ", (Object)this.commitLog);
        }
        catch (Exception ex) {
            LOGGER.error("Processing of {} errored out", (Object)this.commitLog, (Object)ex);
            return new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.ERROR, ex);
        }
        try {
            this.processCommitLog(this.commitLog, new CommitLogPosition(this.commitLog.commitLogSegmentId, 0));
            result = new CommitLogProcessingResult(this.commitLog);
        }
        catch (Exception ex) {
            result = new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.ERROR, ex);
        }
        LOGGER.info("Processing result: {}", (Object)result);
        return result;
    }
}

