/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.KeyspaceTable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaHolder.class);
    private final ConcurrentMap<KeyspaceTable, KeyValueSchema> tableToKVSchemaMap = new ConcurrentHashMap<KeyspaceTable, KeyValueSchema>();

    public KeyValueSchema getKeyValueSchema(KeyspaceTable kst) {
        return this.tableToKVSchemaMap.getOrDefault(kst, null);
    }

    public Set<TableMetadata> getCdcEnabledTableMetadataSet() {
        return this.tableToKVSchemaMap.values().stream().map(KeyValueSchema::tableMetadata).collect(Collectors.toSet());
    }

    protected void removeTableSchema(KeyspaceTable kst) {
        this.tableToKVSchemaMap.remove(kst);
        LOGGER.info("Removed the schema for {}.{} from table schema cache.", (Object)kst.keyspace, (Object)kst.table);
    }

    protected void addOrUpdateTableSchema(KeyspaceTable kst, KeyValueSchema kvs) {
        boolean isUpdate = this.tableToKVSchemaMap.containsKey(kst);
        this.tableToKVSchemaMap.put(kst, kvs);
        if (isUpdate) {
            LOGGER.info("Updated the schema for {}.{} in table schema cache.", (Object)kst.keyspace, (Object)kst.table);
        } else {
            LOGGER.info("Added the schema for {}.{} to table schema cache.", (Object)kst.keyspace, (Object)kst.table);
        }
    }
}

