/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.meters.SnapshotMeter;
import io.debezium.pipeline.metrics.PipelineMetrics;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

@ThreadSafe
public class DefaultSnapshotChangeEventSourceMetrics<P extends Partition>
extends PipelineMetrics<P>
implements SnapshotChangeEventSourceMetrics<P>,
SnapshotChangeEventSourceMetricsMXBean {
    private final SnapshotMeter snapshotMeter;

    public <T extends CdcSourceTaskContext> DefaultSnapshotChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, "snapshot", changeEventQueueMetrics, metadataProvider);
        this.snapshotMeter = new SnapshotMeter(taskContext.getClock());
    }

    public <T extends CdcSourceTaskContext> DefaultSnapshotChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, Map<String, String> tags) {
        super(taskContext, changeEventQueueMetrics, metadataProvider, tags);
        this.snapshotMeter = new SnapshotMeter(taskContext.getClock());
    }

    @Override
    public int getTotalTableCount() {
        return this.snapshotMeter.getTotalTableCount();
    }

    @Override
    public int getRemainingTableCount() {
        return this.snapshotMeter.getRemainingTableCount();
    }

    @Override
    public boolean getSnapshotRunning() {
        return this.snapshotMeter.getSnapshotRunning();
    }

    @Override
    public boolean getSnapshotCompleted() {
        return this.snapshotMeter.getSnapshotCompleted();
    }

    @Override
    public boolean getSnapshotAborted() {
        return this.snapshotMeter.getSnapshotAborted();
    }

    @Override
    public long getSnapshotDurationInSeconds() {
        return this.snapshotMeter.getSnapshotDurationInSeconds();
    }

    @Override
    public String[] getCapturedTables() {
        return this.snapshotMeter.getCapturedTables();
    }

    @Override
    public void monitoredDataCollectionsDetermined(P partition, Iterable<? extends DataCollectionId> dataCollectionIds) {
        this.snapshotMeter.monitoredDataCollectionsDetermined(dataCollectionIds);
    }

    @Override
    public void dataCollectionSnapshotCompleted(P partition, DataCollectionId dataCollectionId, long numRows) {
        this.snapshotMeter.dataCollectionSnapshotCompleted(dataCollectionId, numRows);
    }

    @Override
    public void snapshotStarted(P partition) {
        this.snapshotMeter.snapshotStarted();
    }

    @Override
    public void snapshotCompleted(P partition) {
        this.snapshotMeter.snapshotCompleted();
    }

    @Override
    public void snapshotAborted(P partition) {
        this.snapshotMeter.snapshotAborted();
    }

    @Override
    public void rowsScanned(P partition, TableId tableId, long numRows) {
        this.snapshotMeter.rowsScanned(tableId, numRows);
    }

    public ConcurrentMap<String, Long> getRowsScanned() {
        return this.snapshotMeter.getRowsScanned();
    }

    @Override
    public void currentChunk(P partition, String chunkId, Object[] chunkFrom, Object[] chunkTo) {
        this.snapshotMeter.currentChunk(chunkId, chunkFrom, chunkTo);
    }

    @Override
    public void currentChunk(P partition, String chunkId, Object[] chunkFrom, Object[] chunkTo, Object[] tableTo) {
        this.snapshotMeter.currentChunk(chunkId, chunkFrom, chunkTo, tableTo);
    }

    @Override
    public String getChunkId() {
        return this.snapshotMeter.getChunkId();
    }

    @Override
    public String getChunkFrom() {
        return this.snapshotMeter.getChunkFrom();
    }

    @Override
    public String getChunkTo() {
        return this.snapshotMeter.getChunkTo();
    }

    @Override
    public String getTableFrom() {
        return this.snapshotMeter.getTableFrom();
    }

    @Override
    public String getTableTo() {
        return this.snapshotMeter.getTableTo();
    }

    @Override
    public void reset() {
        super.reset();
        this.snapshotMeter.reset();
    }
}

