/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.schema.AbstractTopicNamingStrategy;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class DefaultRegexTopicNamingStrategy
extends AbstractTopicNamingStrategy<DataCollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegexTopicNamingStrategy.class);
    public static final Field TOPIC_REGEX = Field.create("topic.regex").withDisplayName("Topic regex").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).required().withValidation(Field::isRegex).withDescription("The regex used for extracting the name of the logical table from the original topic name.");
    public static final Field TOPIC_REPLACEMENT = Field.create("topic.replacement").withDisplayName("Topic replacement").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).required().withValidation(DefaultRegexTopicNamingStrategy::validateTopicReplacement).withDescription("The replacement string used in conjunction with " + TOPIC_REGEX.name() + ". This will be used to create the new topic name.");
    private Pattern topicRegex;
    private String topicReplacement;

    private static int validateTopicReplacement(Configuration config, Field field, Field.ValidationOutput problems) {
        String topicReplacement;
        String topicRegex = config.getString(TOPIC_REGEX);
        if (topicRegex != null) {
            topicRegex = topicRegex.trim();
        }
        if ((topicReplacement = config.getString(TOPIC_REPLACEMENT)) != null) {
            topicReplacement = topicReplacement.trim();
        }
        if (!Strings.isNullOrEmpty(topicRegex) && Strings.isNullOrEmpty(topicReplacement)) {
            problems.accept(TOPIC_REPLACEMENT, null, String.format("%s must be non-empty if %s is set.", TOPIC_REPLACEMENT.name(), TOPIC_REGEX.name()));
            return 1;
        }
        return 0;
    }

    public DefaultRegexTopicNamingStrategy(Properties props) {
        super(props);
    }

    @Override
    public void configure(Properties props) {
        super.configure(props);
        Configuration config = Configuration.from(props);
        this.topicRegex = Pattern.compile(config.getString(TOPIC_REGEX));
        this.topicReplacement = config.getString(TOPIC_REPLACEMENT);
    }

    @Override
    public String dataChangeTopic(DataCollectionId id) {
        String oldTopic = this.mkString(Collect.arrayListOf(this.prefix, id.databaseParts()), this.delimiter);
        return this.determineNewTopic(id, this.sanitizedTopicName(oldTopic));
    }

    private String determineNewTopic(DataCollectionId tableId, String oldTopic) {
        String newTopic = (String)this.topicNames.get(tableId);
        if (newTopic == null) {
            newTopic = oldTopic;
            Matcher matcher = this.topicRegex.matcher(oldTopic);
            if (matcher.matches() && (newTopic = matcher.replaceFirst(this.topicReplacement)).isEmpty()) {
                LOGGER.warn("Routing regex returned an empty topic name, propagating original topic");
            }
            this.topicNames.put(tableId, newTopic);
        }
        return newTopic;
    }
}

