/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.CompletableRemoteSyncTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricRemoteSyncTask
extends SyncTask
implements CompletableRemoteSyncTask {
    private static final Logger logger = LoggerFactory.getLogger(SymmetricRemoteSyncTask.class);

    public SymmetricRemoteSyncTask(RepairJobDesc desc, InetAddressAndPort r1, InetAddressAndPort r2, List<Range<Token>> differences, PreviewKind previewKind) {
        super(desc, r1, r2, differences, previewKind);
    }

    void sendRequest(SyncRequest request, InetAddressAndPort to) {
        MessagingService.instance().send(Message.out(Verb.SYNC_REQ, request), to);
    }

    @Override
    protected void startSync() {
        InetAddressAndPort local = FBUtilities.getBroadcastAddressAndPort();
        SyncRequest request = new SyncRequest(this.desc, local, this.nodePair.coordinator, this.nodePair.peer, this.rangesToSync, this.previewKind, false);
        Preconditions.checkArgument((boolean)this.nodePair.coordinator.equals(request.src));
        String message = String.format("Forwarding streaming repair of %d ranges to %s (to be streamed with %s)", request.ranges.size(), request.src, request.dst);
        logger.info("{} {}", (Object)this.previewKind.logPrefix(this.desc.sessionId), (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        this.sendRequest(request, request.src);
    }

    @Override
    public void syncComplete(boolean success, List<SessionSummary> summaries) {
        if (success) {
            this.set(this.stat.withSummaries(summaries));
        } else {
            this.setException(new RepairException(this.desc, this.previewKind, String.format("Sync failed between %s and %s", this.nodePair.coordinator, this.nodePair.peer)));
        }
        this.finished();
    }

    public String toString() {
        return "SymmetricRemoteSyncTask{rangesToSync=" + this.rangesToSync + ", nodePair=" + this.nodePair + '}';
    }
}

