/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class FailSession
extends RepairMessage {
    public final UUID sessionID;
    public static final IVersionedSerializer<FailSession> serializer = new IVersionedSerializer<FailSession>(){

        @Override
        public void serialize(FailSession msg, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(msg.sessionID, out, version);
        }

        @Override
        public FailSession deserialize(DataInputPlus in, int version) throws IOException {
            return new FailSession(UUIDSerializer.serializer.deserialize(in, version));
        }

        @Override
        public long serializedSize(FailSession msg, int version) {
            return UUIDSerializer.serializer.serializedSize(msg.sessionID, version);
        }
    };

    public FailSession(UUID sessionID) {
        super(null);
        assert (sessionID != null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailSession that = (FailSession)o;
        return this.sessionID.equals(that.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }
}

