/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public final class ComponentManifest
implements Iterable<Component> {
    private static final List<Component> STREAM_COMPONENTS = ImmutableList.of((Object)Component.DATA, (Object)Component.PRIMARY_INDEX, (Object)Component.STATS, (Object)Component.COMPRESSION_INFO, (Object)Component.FILTER, (Object)Component.SUMMARY, (Object)Component.DIGEST, (Object)Component.CRC);
    private final LinkedHashMap<Component, Long> components;
    public static final IVersionedSerializer<ComponentManifest> serializer = new IVersionedSerializer<ComponentManifest>(){

        @Override
        public void serialize(ComponentManifest manifest, DataOutputPlus out, int version) throws IOException {
            out.writeUnsignedVInt(manifest.components.size());
            for (Map.Entry entry : manifest.components.entrySet()) {
                out.writeUTF(((Component)entry.getKey()).name);
                out.writeUnsignedVInt((Long)entry.getValue());
            }
        }

        @Override
        public ComponentManifest deserialize(DataInputPlus in, int version) throws IOException {
            int size = (int)in.readUnsignedVInt();
            LinkedHashMap<Component, Long> components = new LinkedHashMap<Component, Long>(size);
            for (int i = 0; i < size; ++i) {
                Component component = Component.parse(in.readUTF());
                long length = in.readUnsignedVInt();
                components.put(component, length);
            }
            return new ComponentManifest(components);
        }

        @Override
        public long serializedSize(ComponentManifest manifest, int version) {
            long size = TypeSizes.sizeofUnsignedVInt(manifest.components.size());
            for (Map.Entry entry : manifest.components.entrySet()) {
                size += (long)TypeSizes.sizeof(((Component)entry.getKey()).name);
                size += (long)TypeSizes.sizeofUnsignedVInt((Long)entry.getValue());
            }
            return size;
        }
    };

    public ComponentManifest(Map<Component, Long> components) {
        this.components = new LinkedHashMap<Component, Long>(components);
    }

    @VisibleForTesting
    public static ComponentManifest create(Descriptor descriptor) {
        LinkedHashMap<Component, Long> components = new LinkedHashMap<Component, Long>(STREAM_COMPONENTS.size());
        for (Component component : STREAM_COMPONENTS) {
            File file = new File(descriptor.filenameFor(component));
            if (!file.exists()) continue;
            components.put(component, file.length());
        }
        return new ComponentManifest(components);
    }

    public long sizeOf(Component component) {
        Long size = this.components.get(component);
        if (size == null) {
            throw new IllegalArgumentException("Component " + component + " is not present in the manifest");
        }
        return size;
    }

    public long totalSize() {
        long totalSize = 0L;
        for (Long size : this.components.values()) {
            totalSize += size.longValue();
        }
        return totalSize;
    }

    public List<Component> components() {
        return new ArrayList<Component>(this.components.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentManifest)) {
            return false;
        }
        ComponentManifest that = (ComponentManifest)o;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    @Override
    public Iterator<Component> iterator() {
        return Iterators.unmodifiableIterator(this.components.keySet().iterator());
    }
}

