/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.session;

import com.datastax.oss.driver.api.core.AsyncAutoCloseable;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.MavenCoordinates;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.DefaultMavenCoordinates;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface Session
extends AsyncAutoCloseable {
    @NonNull
    public static final MavenCoordinates OSS_DRIVER_COORDINATES = DefaultMavenCoordinates.buildFromResourceAndPrint(Session.class.getResource("/com/datastax/oss/driver/Driver.properties"));

    @NonNull
    public String getName();

    @NonNull
    public Metadata getMetadata();

    public boolean isSchemaMetadataEnabled();

    @NonNull
    public CompletionStage<Metadata> setSchemaMetadataEnabled(@Nullable Boolean var1);

    @NonNull
    public CompletionStage<Metadata> refreshSchemaAsync();

    @NonNull
    default public Metadata refreshSchema() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.refreshSchemaAsync());
    }

    @NonNull
    public CompletionStage<Boolean> checkSchemaAgreementAsync();

    default public boolean checkSchemaAgreement() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.checkSchemaAgreementAsync());
    }

    @NonNull
    public DriverContext getContext();

    @NonNull
    public Optional<CqlIdentifier> getKeyspace();

    @NonNull
    public Optional<Metrics> getMetrics();

    @Nullable
    public <RequestT extends Request, ResultT> ResultT execute(@NonNull RequestT var1, @NonNull GenericType<ResultT> var2);
}

