/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.network;

import java.util.Properties;

public class SslConfig {
    public static final String KEY_STORE_LOCATION = "keyStore.location";
    public static final String KEY_STORE_PASSWORD = "keyStore.password";
    public static final String KEY_STORE_TYPE = "keyStore.type";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    public static final String TRUST_STORE_LOCATION = "trustStore.location";
    public static final String TRUST_STORE_PASSWORD = "trustStore.password";
    public static final String TRUST_STORE_TYPE = "trustStore.type";
    public static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    public static final String KEY_MANAGER_ALGORITHM = "keyManager.algorithm";
    public static final String DEFAULT_KEY_MANAGER_ALGORITHM = "SunX509";
    public static final String TRUST_MANAGER_ALGORITHM = "trustManager.algorithm";
    public static final String DEFAULT_TRUST_MANAGER_ALGORITHM = "SunX509";
    public static final String CIPHER_SUITES = "cipherSuites";
    private Properties configs;

    public SslConfig(Properties configs) {
        this.configs = configs;
    }

    public String keyStoreLocation() {
        return (String)this.configs.get(KEY_STORE_LOCATION);
    }

    public String keyStorePassword() {
        return (String)this.configs.get(KEY_STORE_PASSWORD);
    }

    public String keyStoreType() {
        return (String)this.configs.getOrDefault((Object)KEY_STORE_TYPE, "JKS");
    }

    public String getKeyManagerAlgorithm() {
        return (String)this.configs.getOrDefault((Object)KEY_MANAGER_ALGORITHM, "SunX509");
    }

    public String trustStoreLocation() {
        return (String)this.configs.get(TRUST_STORE_LOCATION);
    }

    public String trustStorePassword() {
        return (String)this.configs.get(TRUST_STORE_PASSWORD);
    }

    public String trustStoreType() {
        return (String)this.configs.getOrDefault((Object)TRUST_STORE_TYPE, "JKS");
    }

    public String trustManagerAlgorithm() {
        return (String)this.configs.getOrDefault((Object)TRUST_MANAGER_ALGORITHM, "SunX509");
    }

    public String cipherSuites() {
        return (String)this.configs.get(CIPHER_SUITES);
    }
}

