/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;

public class RolesCache
extends AuthCache<RoleResource, Set<Role>> {
    public RolesCache(IRoleManager roleManager, BooleanSupplier enableCache) {
        super("RolesCache", DatabaseDescriptor::setRolesValidity, DatabaseDescriptor::getRolesValidity, DatabaseDescriptor::setRolesUpdateInterval, DatabaseDescriptor::getRolesUpdateInterval, DatabaseDescriptor::setRolesCacheMaxEntries, DatabaseDescriptor::getRolesCacheMaxEntries, roleManager::getRoleDetails, enableCache);
    }

    Set<RoleResource> getRoleResources(RoleResource primaryRole) {
        return ((Set)this.get(primaryRole)).stream().map(r -> r.resource).collect(Collectors.toSet());
    }

    Set<Role> getRoles(RoleResource primaryRole) {
        return (Set)this.get(primaryRole);
    }
}

