/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.ChangeRecord;
import io.debezium.connector.cassandra.FieldFilterSelector;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.TombstoneRecord;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.function.BlockingConsumer;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;

public class RecordMaker {
    private final boolean emitTombstoneOnDelete;
    private final Filters filters;
    private final CassandraConnectorConfig config;

    public RecordMaker(boolean emitTombstoneOnDelete, Filters filters, CassandraConnectorConfig config) {
        this.emitTombstoneOnDelete = emitTombstoneOnDelete;
        this.filters = filters;
        this.config = config;
    }

    public void insert(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, BlockingConsumer<Record> consumer) {
        this.createRecord(cluster, offsetPosition, keyspaceTable, snapshot, tsMicro, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.INSERT);
    }

    public void update(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, BlockingConsumer<Record> consumer) {
        this.createRecord(cluster, offsetPosition, keyspaceTable, snapshot, tsMicro, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.UPDATE);
    }

    public void delete(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, BlockingConsumer<Record> consumer) {
        this.createRecord(cluster, offsetPosition, keyspaceTable, snapshot, tsMicro, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.DELETE);
    }

    public void rangeTombstone(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, BlockingConsumer<Record> consumer) {
        this.createRecord(cluster, offsetPosition, keyspaceTable, snapshot, tsMicro, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.RANGE_TOMBSTONE);
    }

    private void createRecord(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, BlockingConsumer<Record> consumer, Record.Operation operation) {
        RowData filteredData;
        FieldFilterSelector.FieldFilter fieldFilter = this.filters.getFieldFilter(keyspaceTable);
        switch (operation) {
            case INSERT: 
            case UPDATE: {
                filteredData = fieldFilter.apply(data);
                break;
            }
            default: {
                filteredData = data;
            }
        }
        SourceInfo source = new SourceInfo(this.config, cluster, offsetPosition, keyspaceTable, snapshot, tsMicro);
        ChangeRecord record = new ChangeRecord(source, filteredData, keySchema, valueSchema, operation, markOffset);
        try {
            consumer.accept((Object)record);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new CassandraConnectorTaskException(String.format("Enqueuing has been interrupted while enqueuing Change Event %s", record), e);
        }
        if (operation == Record.Operation.DELETE && this.emitTombstoneOnDelete) {
            TombstoneRecord tombstoneRecord = new TombstoneRecord(source, filteredData, keySchema);
            try {
                consumer.accept((Object)tombstoneRecord);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new CassandraConnectorTaskException(String.format("Enqueuing has been interrupted while enqueuing Tombstone Event %s", record), e);
            }
        }
    }
}

