/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.codahale.metrics.servlets.PingServlet;
import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CassandraConnectorTaskHealthCheck;
import io.debezium.connector.cassandra.CassandraSpecificProcessors;
import io.debezium.connector.cassandra.CommitLogPostProcessor;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.QueueProcessor;
import io.debezium.connector.cassandra.SchemaChangeListenerProvider;
import io.debezium.connector.cassandra.SchemaLoader;
import io.debezium.connector.cassandra.SnapshotProcessor;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.connector.cassandra.network.BuildInfoServlet;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraConnectorTaskTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraConnectorTaskTemplate.class);
    public static final MetricRegistry METRIC_REGISTRY_INSTANCE = new MetricRegistry();
    private final CassandraConnectorConfig config;
    private CassandraConnectorContext taskContext;
    private ProcessorGroup processorGroup;
    private Server httpServer;
    private JmxReporter jmxReporter;
    private SchemaLoader schemaLoader;
    private SchemaChangeListenerProvider schemaChangeListenerProvider;
    private CassandraSpecificProcessors cassandraSpecificProcessors;

    public static void main(String[] args, Function<CassandraConnectorConfig, CassandraConnectorTaskTemplate> template) throws Exception {
        if (args.length == 0) {
            throw new CassandraConnectorConfigException("CDC config file is required");
        }
        try (FileInputStream fis = new FileInputStream(args[0]);){
            CassandraConnectorConfig config = new CassandraConnectorConfig(Configuration.load((InputStream)fis));
            template.apply(config).run();
        }
    }

    public CassandraConnectorTaskTemplate(CassandraConnectorConfig config, SchemaLoader schemaLoader, SchemaChangeListenerProvider schemaChangeListener, CassandraSpecificProcessors cassandraSpecificProcessors) {
        this.config = config;
        this.schemaLoader = schemaLoader;
        this.schemaChangeListenerProvider = schemaChangeListener;
        this.cassandraSpecificProcessors = cassandraSpecificProcessors;
    }

    private void initJmxReporter(String domain) {
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)METRIC_REGISTRY_INSTANCE).inDomain(domain).build();
    }

    private HealthCheckRegistry registerHealthCheck() {
        CassandraConnectorTaskHealthCheck healthCheck = new CassandraConnectorTaskHealthCheck(this.processorGroup, this.taskContext.getCassandraClient());
        HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();
        healthCheckRegistry.register("cassandra-cdc-health-check", (HealthCheck)healthCheck);
        return healthCheckRegistry;
    }

    private static Map<String, String> getBuildInfoMap(Class<?> clazz) {
        HashMap<String, String> buildInfo = new HashMap<String, String>();
        buildInfo.put("version", clazz.getPackage().getImplementationVersion());
        buildInfo.put("service_name", clazz.getPackage().getImplementationTitle());
        return buildInfo;
    }

    void run() throws Exception {
        try {
            if (!this.config.validateAndRecord((Iterable)CassandraConnectorConfig.VALIDATION_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
                throw new CassandraConnectorConfigException("Failed to start connector with invalid configuration (see logs for actual errors)");
            }
            LOGGER.info("Initializing Cassandra connector task context ...");
            this.taskContext = new CassandraConnectorContext(this.config, this.schemaLoader, this.schemaChangeListenerProvider);
            LOGGER.info("Starting processor group ...");
            AbstractProcessor[] processors = this.cassandraSpecificProcessors.getProcessors(this.taskContext);
            this.processorGroup = this.initProcessorGroup(this.taskContext, processors);
            this.processorGroup.start();
            LOGGER.info("Starting HTTP server ...");
            this.initHttpServer();
            this.httpServer.start();
            LOGGER.info("Starting JMX reporter ...");
            this.initJmxReporter(this.config.connectorName());
            this.jmxReporter.start();
            while (this.processorGroup.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        finally {
            this.stopAll();
        }
    }

    public CassandraConnectorContext getTaskContext() {
        return this.taskContext;
    }

    protected ProcessorGroup initProcessorGroup(CassandraConnectorContext taskContext, AbstractProcessor ... cassandraSpecificProcessors) {
        try {
            ProcessorGroup processorGroup = new ProcessorGroup();
            for (AbstractProcessor processor : cassandraSpecificProcessors) {
                processorGroup.addProcessor(processor);
            }
            processorGroup.addProcessor(new SnapshotProcessor(taskContext));
            List<ChangeEventQueue<Event>> queues = taskContext.getQueues();
            for (int i = 0; i < queues.size(); ++i) {
                processorGroup.addProcessor(new QueueProcessor(taskContext, i));
            }
            if (taskContext.getCassandraConnectorConfig().postProcessEnabled()) {
                processorGroup.addProcessor(new CommitLogPostProcessor(taskContext.getCassandraConnectorConfig()));
            }
            LOGGER.info("Initialized Processor Group.");
            return processorGroup;
        }
        catch (Exception e) {
            throw new CassandraConnectorTaskException("Failed to initialize Processor Group.", e);
        }
    }

    private void initHttpServer() {
        int httpPort = this.config.httpPort();
        LOGGER.debug("HTTP port is {}", (Object)httpPort);
        this.httpServer = new Server(httpPort);
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/");
        this.httpServer.setHandler((Handler)contextHandler);
        contextHandler.addServlet(new ServletHolder((Servlet)new PingServlet()), "/ping");
        contextHandler.addServlet(new ServletHolder((Servlet)new BuildInfoServlet(CassandraConnectorTaskTemplate.getBuildInfoMap(this.getClass()))), "/buildinfo");
        contextHandler.addServlet(new ServletHolder((Servlet)new MetricsServlet(METRIC_REGISTRY_INSTANCE)), "/metrics");
        contextHandler.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(this.registerHealthCheck())), "/health");
    }

    public void stopAll() throws Exception {
        LOGGER.info("Stopping Cassandra Connector Task ...");
        if (this.processorGroup != null) {
            this.processorGroup.terminate();
            LOGGER.info("Terminated processor group.");
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
            LOGGER.info("Stopped HTTP server.");
        }
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
            LOGGER.info("Stopped JMX reporter.");
        }
        if (this.taskContext != null) {
            this.taskContext.cleanUp();
            LOGGER.info("Cleaned up Cassandra connector context.");
        }
        LOGGER.info("Stopped Cassandra Connector Task.");
    }

    public static class ProcessorGroup {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorGroup.class);
        private final Set<AbstractProcessor> processors = new HashSet<AbstractProcessor>();
        private ExecutorService executorService;

        ProcessorGroup() {
        }

        public boolean isRunning() {
            for (AbstractProcessor processor : this.processors) {
                if (processor.isRunning()) continue;
                return false;
            }
            return true;
        }

        void addProcessor(AbstractProcessor processor) {
            this.processors.add(processor);
        }

        void start() {
            this.executorService = Executors.newFixedThreadPool(this.processors.size());
            for (AbstractProcessor processor : this.processors) {
                Runnable runnable = () -> {
                    try {
                        processor.initialize();
                        processor.start();
                    }
                    catch (Exception e) {
                        LOGGER.error("Encountered exception while running {}; stopping all processors.", (Object)processor.getName(), (Object)e);
                        try {
                            this.stopProcessors();
                        }
                        catch (Exception e2) {
                            LOGGER.error("Encountered exceptions while stopping all processors", (Throwable)e2);
                        }
                    }
                };
                this.executorService.submit(runnable);
            }
        }

        void terminate() {
            LOGGER.info("Terminating processor group ...");
            try {
                this.stopProcessors();
                if (this.executorService != null && !this.executorService.isShutdown()) {
                    this.executorService.shutdown();
                    if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
            }
            catch (Exception e) {
                throw new CassandraConnectorTaskException("Failed to terminate processor group.", e);
            }
        }

        private void stopProcessors() throws Exception {
            for (AbstractProcessor processor : this.processors) {
                processor.stop();
                processor.destroy();
            }
        }
    }
}

