/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.AbstractSchemaChangeListener;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SourceInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra4SchemaChangeListener
extends AbstractSchemaChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cassandra4SchemaChangeListener.class);

    public Cassandra4SchemaChangeListener(String kafkaTopicPrefix, SourceInfoStructMaker<SourceInfo> sourceInfoStructMaker, SchemaHolder schemaHolder) {
        super(kafkaTopicPrefix, sourceInfoStructMaker, schemaHolder);
    }

    public void onSessionReady(Session session) {
        LOGGER.info("Initializing SchemaHolder ...");
        List cdcEnabledTableMetadataList = this.getCdcEnabledTableMetadataList(session);
        for (TableMetadata tm : cdcEnabledTableMetadataList) {
            this.schemaHolder.addOrUpdateTableSchema(new KeyspaceTable(tm), new KeyValueSchema(this.kafkaTopicPrefix, tm, this.sourceInfoStructMaker));
            this.onKeyspaceCreated((KeyspaceMetadata)session.getMetadata().getKeyspace(tm.getKeyspace().toString()).get());
            this.onTableCreated(tm);
        }
        Set cdcEnabledEntities = this.schemaHolder.getCdcEnabledTableMetadataSet().stream().map(tmd -> tmd.describe(true)).collect(Collectors.toSet());
        LOGGER.info("CDC enabled entities: {}", cdcEnabledEntities);
        LOGGER.info("Initialized SchemaHolder.");
    }

    public void onKeyspaceCreated(KeyspaceMetadata keyspaceMetadata) {
        try {
            Schema.instance.load(org.apache.cassandra.schema.KeyspaceMetadata.create((String)keyspaceMetadata.getName().toString(), (KeyspaceParams)KeyspaceParams.create((boolean)keyspaceMetadata.isDurableWrites(), (Map)keyspaceMetadata.getReplication())));
            Keyspace.openWithoutSSTables((String)keyspaceMetadata.getName().toString());
            LOGGER.info("Added keyspace [{}] to schema instance.", (Object)keyspaceMetadata.describe(true));
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while adding the keyspace {} to schema instance.", (Object)keyspaceMetadata.getName(), (Object)e);
        }
    }

    public void onKeyspaceUpdated(KeyspaceMetadata current, KeyspaceMetadata previous) {
        try {
            Schema.instance.load(org.apache.cassandra.schema.KeyspaceMetadata.create((String)current.getName().toString(), (KeyspaceParams)KeyspaceParams.create((boolean)current.isDurableWrites(), (Map)current.getReplication())));
            LOGGER.info("Updated keyspace [{}] in schema instance.", (Object)current.describe(true));
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while updating the keyspace {} in schema instance.", (Object)current.getName(), (Object)e);
        }
    }

    public void onKeyspaceDropped(KeyspaceMetadata keyspaceMetadata) {
        try {
            Schema.instance.removeKeyspaceInstance(keyspaceMetadata.getName().toString());
            LOGGER.info("Removed keyspace [{}] from schema instance.", (Object)keyspaceMetadata.describe(true));
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while removing the keyspace {} from schema instance.", (Object)keyspaceMetadata.getName(), (Object)e);
        }
    }

    public void onTableCreated(TableMetadata tableMetadata) {
        Object cdc = tableMetadata.getOptions().get(CqlIdentifier.fromInternal((String)"cdc"));
        boolean cdcEnabled = cdc.toString().equals("true");
        if (cdcEnabled) {
            this.schemaHolder.addOrUpdateTableSchema(new KeyspaceTable(tableMetadata), new KeyValueSchema(this.kafkaTopicPrefix, tableMetadata, this.sourceInfoStructMaker));
        }
        try {
            LOGGER.info("Table {}.{} detected to be added!", (Object)tableMetadata.getKeyspace(), (Object)tableMetadata.getName());
            org.apache.cassandra.schema.TableMetadata.builder((String)tableMetadata.getKeyspace().toString(), (String)tableMetadata.getName().toString());
            UUID uuid = (UUID)tableMetadata.getId().get();
            org.apache.cassandra.schema.TableMetadata metadata = CreateTableStatement.parse((String)tableMetadata.describe(true), (String)tableMetadata.getKeyspace().toString()).id(TableId.fromUUID((UUID)uuid)).build();
            Keyspace keyspace = Keyspace.openWithoutSSTables((String)tableMetadata.getKeyspace().asInternal());
            if (keyspace.hasColumnFamilyStore(metadata.id)) {
                return;
            }
            keyspace.initCfCustom(ColumnFamilyStore.createColumnFamilyStore((Keyspace)keyspace, (String)metadata.name, (TableMetadataRef)TableMetadataRef.forOfflineTools((org.apache.cassandra.schema.TableMetadata)metadata), (Directories)new Directories(metadata), (boolean)false, (boolean)false, (boolean)true));
            org.apache.cassandra.schema.KeyspaceMetadata current = Schema.instance.getKeyspaceMetadata(metadata.keyspace);
            if (current == null) {
                LOGGER.warn("Keyspace {} doesn't exist", (Object)metadata.keyspace);
                return;
            }
            if (current.tables.get(tableMetadata.getName().toString()).isPresent()) {
                LOGGER.debug("Table {}.{} is already added!", (Object)tableMetadata.getKeyspace(), (Object)tableMetadata.getName());
                return;
            }
            org.apache.cassandra.schema.KeyspaceMetadata transformed = current.withSwapped(current.tables.with(metadata));
            Schema.instance.load(transformed);
            LOGGER.info("Added table [{}] to schema instance.", (Object)tableMetadata.describe(true));
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while adding table {}.{} to schema instance.", new Object[]{tableMetadata.getKeyspace(), tableMetadata.getName(), e});
        }
    }

    public void onTableDropped(TableMetadata tableMetadata) {
        Object cdc = tableMetadata.getOptions().get(CqlIdentifier.fromInternal((String)"cdc"));
        boolean cdcEnabled = cdc.toString().equals("true");
        if (cdcEnabled) {
            this.schemaHolder.removeTableSchema(new KeyspaceTable(tableMetadata));
        }
        try {
            ColumnFamilyStore cfs;
            String ksName = tableMetadata.getKeyspace().toString();
            String tableName = tableMetadata.getName().toString();
            LOGGER.debug("Table {}.{} detected to be removed!", (Object)ksName, (Object)tableName);
            org.apache.cassandra.schema.KeyspaceMetadata oldKsm = Schema.instance.getKeyspaceMetadata(ksName);
            if (oldKsm == null) {
                LOGGER.warn("KeyspaceMetadata for keyspace {} is not found!", (Object)ksName);
                return;
            }
            org.apache.cassandra.schema.TableMetadata metadata = Schema.instance.getTableMetadata(TableId.fromUUID((UUID)((UUID)tableMetadata.getId().get())));
            if (metadata == null) {
                LOGGER.warn("Metadata for ColumnFamilyStore for {}.{} is not found!", (Object)ksName, (Object)tableName);
                return;
            }
            Keyspace instance = Schema.instance.getKeyspaceInstance(metadata.keyspace);
            if (instance == null) {
                LOGGER.warn("Keyspace instance for ColumnFamilyStore for {}.{} is not found!", (Object)ksName, (Object)tableName);
                return;
            }
            ColumnFamilyStore columnFamilyStore = cfs = instance.hasColumnFamilyStore(metadata.id) ? instance.getColumnFamilyStore(metadata.id) : null;
            if (cfs == null) {
                LOGGER.warn("ColumnFamilyStore for {}.{} is not found!", (Object)ksName, (Object)tableName);
                return;
            }
            cfs.indexManager.markAllIndexesRemoved();
            Optional cfm = oldKsm.tables.get(tableName);
            if (cfm.isPresent()) {
                org.apache.cassandra.schema.KeyspaceMetadata newKsm = oldKsm.withSwapped(oldKsm.tables.without(tableName));
                Schema.instance.load(newKsm);
                LOGGER.info("Removed table [{}] from schema instance.", (Object)tableMetadata.describe(true));
            } else {
                LOGGER.warn("Table {}.{} is not present in old keyspace meta data!", (Object)ksName, (Object)tableName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while removing table {}.{} from schema instance.", new Object[]{tableMetadata.getKeyspace(), tableMetadata.getName(), e});
        }
    }

    public void onTableUpdated(TableMetadata newTableMetadata, TableMetadata oldTableMetaData) {
        Object newCdcObject = newTableMetadata.getOptions().get(CqlIdentifier.fromInternal((String)"cdc"));
        boolean newCdc = newCdcObject.toString().equals("true");
        Object oldCdcObject = oldTableMetaData.getOptions().get(CqlIdentifier.fromInternal((String)"cdc"));
        boolean oldCdc = oldCdcObject.toString().equals("true");
        if (newCdc) {
            this.schemaHolder.addOrUpdateTableSchema(new KeyspaceTable(newTableMetadata), new KeyValueSchema(this.kafkaTopicPrefix, newTableMetadata, this.sourceInfoStructMaker));
        } else if (oldCdc) {
            this.schemaHolder.removeTableSchema(new KeyspaceTable(newTableMetadata));
        }
        try {
            LOGGER.debug("Detected alternation in schema of {}.{} (previous cdc = {}, current cdc = {})", new Object[]{newTableMetadata.getKeyspace(), newTableMetadata.getName(), oldCdc, newCdc});
            UUID uuid = UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])newTableMetadata.getKeyspace().toString().getBytes(), (byte[])newTableMetadata.getName().toString().getBytes()));
            org.apache.cassandra.schema.TableMetadata metadata = CreateTableStatement.parse((String)newTableMetadata.describe(true), (String)newTableMetadata.getKeyspace().toString()).id(TableId.fromUUID((UUID)uuid)).build();
            org.apache.cassandra.schema.KeyspaceMetadata current = Schema.instance.getKeyspaceMetadata(metadata.keyspace);
            if (current != null) {
                current.tables.withSwapped(metadata);
                Schema.instance.load(current);
            }
            LOGGER.info("Updated table [{}] in schema instance.", (Object)newTableMetadata.describe(true));
        }
        catch (Exception e) {
            LOGGER.warn("Error happened while reacting on changed table {}.{} in schema instance.", new Object[]{newTableMetadata.getKeyspace(), newTableMetadata.getName(), e});
        }
    }
}

