/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hyperic.sigar.util.GetlineCompleter;

public class Getline {
    private static final boolean isatty = Getline.isatty();
    private static boolean useNative = !"false".equals(System.getProperty("sigar.getline.native")) && isatty;
    private BufferedReader in = null;
    private String prompt = "> ";

    public Getline() {
    }

    public Getline(String prompt) {
        this.prompt = prompt;
    }

    private static native boolean isatty();

    public static native void setCompleter(GetlineCompleter var0);

    public native void redraw();

    public native void reset();

    private native void histadd(String var1);

    private native void histinit(String var1);

    private native String getline(String var1) throws IOException, EOFException;

    public static boolean isTTY() {
        return isatty;
    }

    public String getLine() throws IOException, EOFException {
        return this.getLine(this.prompt, true);
    }

    public String getLine(String prompt) throws IOException, EOFException {
        return this.getLine(prompt, true);
    }

    public String getLine(String prompt, boolean addToHistory) throws IOException, EOFException {
        if (useNative) {
            String line = this.getline(prompt);
            if (addToHistory) {
                this.addToHistory(line);
            }
            return line;
        }
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(System.in));
        }
        System.out.print(prompt);
        return this.in.readLine();
    }

    public void initHistoryFile(File file) throws IOException {
        if (useNative) {
            this.histinit(file.getCanonicalPath());
        }
    }

    public void addToHistory(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        if (useNative) {
            this.histadd(line);
        }
    }
}

