/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.utils.AbstractIterator;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unmetered
public class TableMetadata
implements SchemaElement {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadata.class);
    public final String keyspace;
    public final String name;
    public final TableId id;
    public final IPartitioner partitioner;
    public final Kind kind;
    public final TableParams params;
    public final ImmutableSet<Flag> flags;
    @Nullable
    private final String indexName;
    public final ImmutableMap<ByteBuffer, DroppedColumn> droppedColumns;
    final ImmutableMap<ByteBuffer, ColumnMetadata> columns;
    protected final ImmutableList<ColumnMetadata> partitionKeyColumns;
    protected final ImmutableList<ColumnMetadata> clusteringColumns;
    protected final RegularAndStaticColumns regularAndStaticColumns;
    public final Indexes indexes;
    public final Triggers triggers;
    public final AbstractType<?> partitionKeyType;
    public final ClusteringComparator comparator;
    public final DataResource resource;

    protected TableMetadata(Builder builder) {
        this.flags = Sets.immutableEnumSet((Iterable)builder.flags);
        this.keyspace = builder.keyspace;
        this.name = builder.name;
        this.id = builder.id;
        this.partitioner = builder.partitioner;
        this.kind = builder.kind;
        this.params = builder.params.build();
        this.indexName = this.kind == Kind.INDEX ? this.name.substring(this.name.indexOf(46) + 1) : null;
        this.droppedColumns = ImmutableMap.copyOf((Map)builder.droppedColumns);
        Collections.sort(builder.partitionKeyColumns);
        this.partitionKeyColumns = ImmutableList.copyOf((Collection)builder.partitionKeyColumns);
        Collections.sort(builder.clusteringColumns);
        this.clusteringColumns = ImmutableList.copyOf((Collection)builder.clusteringColumns);
        this.regularAndStaticColumns = RegularAndStaticColumns.builder().addAll(builder.regularAndStaticColumns).build();
        this.columns = ImmutableMap.copyOf((Map)builder.columns);
        this.indexes = builder.indexes;
        this.triggers = builder.triggers;
        this.partitionKeyType = this.partitionKeyColumns.size() == 1 ? ((ColumnMetadata)this.partitionKeyColumns.get((int)0)).type : CompositeType.getInstance(Iterables.transform(this.partitionKeyColumns, t -> t.type));
        this.comparator = new ClusteringComparator(Iterables.transform(this.clusteringColumns, c -> c.type));
        this.resource = DataResource.table(this.keyspace, this.name);
    }

    public static Builder builder(String keyspace, String table) {
        return new Builder(keyspace, table);
    }

    public static Builder builder(String keyspace, String table, TableId id) {
        return new Builder(keyspace, table, id);
    }

    public Builder unbuild() {
        return TableMetadata.builder(this.keyspace, this.name, this.id).partitioner(this.partitioner).kind(this.kind).params(this.params).flags((Set<Flag>)this.flags).addColumns((Iterable<ColumnMetadata>)this.columns()).droppedColumns((Map<ByteBuffer, DroppedColumn>)this.droppedColumns).indexes(this.indexes).triggers(this.triggers);
    }

    public boolean isIndex() {
        return this.kind == Kind.INDEX;
    }

    public TableMetadata withSwapped(TableParams params) {
        return this.unbuild().params(params).build();
    }

    public TableMetadata withSwapped(Set<Flag> flags) {
        return this.unbuild().flags(flags).build();
    }

    public TableMetadata withSwapped(Triggers triggers) {
        return this.unbuild().triggers(triggers).build();
    }

    public TableMetadata withSwapped(Indexes indexes) {
        return this.unbuild().indexes(indexes).build();
    }

    public boolean isView() {
        return this.kind == Kind.VIEW;
    }

    public boolean isVirtual() {
        return this.kind == Kind.VIRTUAL;
    }

    public Optional<String> indexName() {
        return Optional.ofNullable(this.indexName);
    }

    public boolean isCounter() {
        return this.flags.contains((Object)Flag.COUNTER);
    }

    public boolean isCompactTable() {
        return false;
    }

    public boolean isStaticCompactTable() {
        return false;
    }

    public ImmutableCollection<ColumnMetadata> columns() {
        return this.columns.values();
    }

    public Iterable<ColumnMetadata> primaryKeyColumns() {
        return Iterables.concat(this.partitionKeyColumns, this.clusteringColumns);
    }

    public ImmutableList<ColumnMetadata> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public ImmutableList<ColumnMetadata> clusteringColumns() {
        return this.clusteringColumns;
    }

    public RegularAndStaticColumns regularAndStaticColumns() {
        return this.regularAndStaticColumns;
    }

    public Columns regularColumns() {
        return this.regularAndStaticColumns.regulars;
    }

    public Columns staticColumns() {
        return this.regularAndStaticColumns.statics;
    }

    public Iterator<ColumnMetadata> allColumnsInSelectOrder() {
        UnmodifiableIterator partitionKeyIter = this.partitionKeyColumns.iterator();
        UnmodifiableIterator clusteringIter = this.clusteringColumns.iterator();
        Iterator<ColumnMetadata> otherColumns = this.regularAndStaticColumns.selectOrderIterator();
        return TableMetadata.columnsIterator((Iterator<ColumnMetadata>)partitionKeyIter, (Iterator<ColumnMetadata>)clusteringIter, otherColumns);
    }

    public Iterator<ColumnMetadata> allColumnsInCreateOrder() {
        UnmodifiableIterator partitionKeyIter = this.partitionKeyColumns.iterator();
        UnmodifiableIterator clusteringIter = this.clusteringColumns.iterator();
        Iterator<ColumnMetadata> otherColumns = this.regularAndStaticColumns.iterator();
        return TableMetadata.columnsIterator((Iterator<ColumnMetadata>)partitionKeyIter, (Iterator<ColumnMetadata>)clusteringIter, otherColumns);
    }

    private static Iterator<ColumnMetadata> columnsIterator(final Iterator<ColumnMetadata> partitionKeys, final Iterator<ColumnMetadata> clusteringColumns, final Iterator<ColumnMetadata> otherColumns) {
        return new AbstractIterator<ColumnMetadata>(){

            @Override
            protected ColumnMetadata computeNext() {
                if (partitionKeys.hasNext()) {
                    return (ColumnMetadata)partitionKeys.next();
                }
                if (clusteringColumns.hasNext()) {
                    return (ColumnMetadata)clusteringColumns.next();
                }
                return otherColumns.hasNext() ? (ColumnMetadata)otherColumns.next() : (ColumnMetadata)this.endOfData();
            }
        };
    }

    public ColumnMetadata getColumn(ColumnIdentifier name) {
        return (ColumnMetadata)this.columns.get((Object)name.bytes);
    }

    public ColumnMetadata getExistingColumn(ColumnIdentifier name) {
        ColumnMetadata def = this.getColumn(name);
        if (def == null) {
            throw new InvalidRequestException(String.format("Undefined column name %s in table %s", name.toCQLString(), this));
        }
        return def;
    }

    public ColumnMetadata getColumn(ByteBuffer name) {
        return (ColumnMetadata)this.columns.get((Object)name);
    }

    public ColumnMetadata getDroppedColumn(ByteBuffer name) {
        DroppedColumn dropped = (DroppedColumn)this.droppedColumns.get((Object)name);
        return dropped == null ? null : dropped.column;
    }

    public ColumnMetadata getDroppedColumn(ByteBuffer name, boolean isStatic) {
        DroppedColumn dropped = (DroppedColumn)this.droppedColumns.get((Object)name);
        if (dropped == null) {
            return null;
        }
        if (isStatic && !dropped.column.isStatic()) {
            return ColumnMetadata.staticColumn(this, name, dropped.column.type);
        }
        return dropped.column;
    }

    public boolean hasStaticColumns() {
        return !this.staticColumns().isEmpty();
    }

    public void validate() {
        if (!IndexMetadata.isNameValid(this.keyspace)) {
            this.except("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.keyspace);
        }
        if (!IndexMetadata.isNameValid(this.name)) {
            this.except("Table name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name);
        }
        this.params.validate();
        if (this.partitionKeyColumns.stream().anyMatch(c -> c.type.isCounter())) {
            this.except("PRIMARY KEY columns cannot contain counters", new Object[0]);
        }
        if (this.isCounter()) {
            for (ColumnMetadata column : this.regularAndStaticColumns) {
                if (column.type.isCounter() || TableMetadata.isSuperColumnMapColumnName(column.name)) continue;
                this.except("Cannot have a non counter column (\"%s\") in a counter table", column.name);
            }
        } else {
            for (ColumnMetadata column : this.regularAndStaticColumns) {
                if (!column.type.isCounter()) continue;
                this.except("Cannot have a counter column (\"%s\") in a non counter table", column.name);
            }
        }
        if (this.partitionKeyColumns.isEmpty()) {
            this.except("Missing partition keys for table %s", this.toString());
        }
        this.indexes.validate(this);
    }

    private static boolean isSuperColumnMapColumnName(ColumnIdentifier columnName) {
        return !columnName.bytes.hasRemaining();
    }

    void validateCompatibility(TableMetadata previous) {
        int i;
        if (this.isIndex()) {
            return;
        }
        if (!previous.keyspace.equals(this.keyspace)) {
            this.except("Keyspace mismatch (found %s; expected %s)", this.keyspace, previous.keyspace);
        }
        if (!previous.name.equals(this.name)) {
            this.except("Table mismatch (found %s; expected %s)", this.name, previous.name);
        }
        if (!previous.id.equals(this.id)) {
            this.except("Table ID mismatch (found %s; expected %s)", this.id, previous.id);
        }
        if (!(previous.flags.equals(this.flags) || Flag.isCQLTable(this.flags) && !Flag.isCQLTable(previous.flags))) {
            this.except("Table type mismatch (found %s; expected %s)", this.flags, previous.flags);
        }
        if (previous.partitionKeyColumns.size() != this.partitionKeyColumns.size()) {
            this.except("Partition keys of different length (found %s; expected %s)", this.partitionKeyColumns.size(), previous.partitionKeyColumns.size());
        }
        for (i = 0; i < this.partitionKeyColumns.size(); ++i) {
            if (((ColumnMetadata)this.partitionKeyColumns.get((int)i)).type.isCompatibleWith(((ColumnMetadata)previous.partitionKeyColumns.get((int)i)).type)) continue;
            this.except("Partition key column mismatch (found %s; expected %s)", ((ColumnMetadata)this.partitionKeyColumns.get((int)i)).type, ((ColumnMetadata)previous.partitionKeyColumns.get((int)i)).type);
        }
        if (previous.clusteringColumns.size() != this.clusteringColumns.size()) {
            this.except("Clustering columns of different length (found %s; expected %s)", this.clusteringColumns.size(), previous.clusteringColumns.size());
        }
        for (i = 0; i < this.clusteringColumns.size(); ++i) {
            if (((ColumnMetadata)this.clusteringColumns.get((int)i)).type.isCompatibleWith(((ColumnMetadata)previous.clusteringColumns.get((int)i)).type)) continue;
            this.except("Clustering column mismatch (found %s; expected %s)", ((ColumnMetadata)this.clusteringColumns.get((int)i)).type, ((ColumnMetadata)previous.clusteringColumns.get((int)i)).type);
        }
        for (ColumnMetadata previousColumn : previous.regularAndStaticColumns) {
            ColumnMetadata column = this.getColumn(previousColumn.name);
            if (column == null || column.type.isCompatibleWith(previousColumn.type)) continue;
            this.except("Column mismatch (found %s; expected %s)", column, previousColumn);
        }
    }

    public ClusteringComparator partitionKeyAsClusteringComparator() {
        return new ClusteringComparator(this.partitionKeyColumns.stream().map(c -> c.type).collect(Collectors.toList()));
    }

    public String indexTableName(IndexMetadata info) {
        return this.name + "." + info.name;
    }

    boolean changeAffectsPreparedStatements(TableMetadata updated) {
        return !this.partitionKeyColumns.equals(updated.partitionKeyColumns) || !this.clusteringColumns.equals(updated.clusteringColumns) || !this.regularAndStaticColumns.equals(updated.regularAndStaticColumns) || !this.indexes.equals(updated.indexes) || this.params.defaultTimeToLive != updated.params.defaultTimeToLive || this.params.gcGraceSeconds != updated.params.gcGraceSeconds || !Flag.isCQLTable(this.flags) && Flag.isCQLTable(updated.flags);
    }

    public static TableMetadata minimal(String keyspace, String name) {
        return TableMetadata.builder(keyspace, name).addPartitionKeyColumn("key", (AbstractType)BytesType.instance).build();
    }

    public TableMetadata updateIndexTableMetadata(TableParams baseTableParams) {
        TableParams.Builder builder = baseTableParams.unbuild().gcGraceSeconds(0);
        builder.caching(baseTableParams.caching.cacheKeys() ? CachingParams.CACHE_KEYS : CachingParams.CACHE_NOTHING);
        return this.unbuild().params(builder.build()).build();
    }

    boolean referencesUserType(ByteBuffer name) {
        return Iterables.any(this.columns(), c -> c.type.referencesUserType(name));
    }

    public TableMetadata withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        Builder builder = this.unbuild();
        this.columns().forEach(c -> builder.alterColumnType(c.name, c.type.withUpdatedUserType(udt)));
        return builder.build();
    }

    protected void except(String format, Object ... args) {
        throw new ConfigurationException(this.keyspace + "." + this.name + ": " + String.format(format, args));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMetadata)) {
            return false;
        }
        TableMetadata tm = (TableMetadata)o;
        return this.equalsWithoutColumns(tm) && this.columns.equals(tm.columns);
    }

    private boolean equalsWithoutColumns(TableMetadata tm) {
        return this.keyspace.equals(tm.keyspace) && this.name.equals(tm.name) && this.id.equals(tm.id) && this.partitioner.equals(tm.partitioner) && this.kind == tm.kind && this.params.equals(tm.params) && this.flags.equals(tm.flags) && this.droppedColumns.equals(tm.droppedColumns) && this.indexes.equals(tm.indexes) && this.triggers.equals(tm.triggers);
    }

    Optional<Difference> compare(TableMetadata other) {
        return this.equalsWithoutColumns(other) ? this.compareColumns((Map<ByteBuffer, ColumnMetadata>)other.columns) : Optional.of(Difference.SHALLOW);
    }

    private Optional<Difference> compareColumns(Map<ByteBuffer, ColumnMetadata> other) {
        if (!this.columns.keySet().equals(other.keySet())) {
            return Optional.of(Difference.SHALLOW);
        }
        boolean differsDeeply = false;
        for (Map.Entry entry : this.columns.entrySet()) {
            ColumnMetadata thatColumn;
            ColumnMetadata thisColumn = (ColumnMetadata)entry.getValue();
            Optional<Difference> difference = thisColumn.compare(thatColumn = other.get(entry.getKey()));
            if (!difference.isPresent()) continue;
            switch (difference.get()) {
                case SHALLOW: {
                    return difference;
                }
                case DEEP: {
                    differsDeeply = true;
                }
            }
        }
        return differsDeeply ? Optional.of(Difference.DEEP) : Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyspace, this.name, this.id, this.partitioner, this.kind, this.params, this.flags, this.columns, this.droppedColumns, this.indexes, this.triggers});
    }

    public String toString() {
        return String.format("%s.%s", ColumnIdentifier.maybeQuote(this.keyspace), ColumnIdentifier.maybeQuote(this.name));
    }

    public String toDebugString() {
        return MoreObjects.toStringHelper((Object)this).add("keyspace", (Object)this.keyspace).add("table", (Object)this.name).add("id", (Object)this.id).add("partitioner", (Object)this.partitioner).add("kind", (Object)this.kind).add("params", (Object)this.params).add("flags", this.flags).add("columns", this.columns()).add("droppedColumns", (Object)this.droppedColumns.values()).add("indexes", (Object)this.indexes).add("triggers", (Object)this.triggers).toString();
    }

    public boolean enforceStrictLiveness() {
        return this.isView() && Keyspace.open((String)this.keyspace).viewManager.getByName(this.name).enforceStrictLiveness();
    }

    public Set<ByteBuffer> getReferencedUserTypes() {
        LinkedHashSet<ByteBuffer> types = new LinkedHashSet<ByteBuffer>();
        this.columns().forEach(c -> TableMetadata.addUserTypes(c.type, types));
        return types;
    }

    private static void addUserTypes(AbstractType<?> type, Set<ByteBuffer> types) {
        type.subTypes().forEach(t -> TableMetadata.addUserTypes(t, types));
        if (type.isUDT()) {
            types.add(((UserType)type).name);
        }
    }

    @Override
    public SchemaElement.SchemaElementType elementType() {
        return SchemaElement.SchemaElementType.TABLE;
    }

    @Override
    public String elementKeyspace() {
        return this.keyspace;
    }

    @Override
    public String elementName() {
        return this.name;
    }

    @Override
    public String toCqlString(boolean withInternals, boolean ifNotExists) {
        CqlBuilder builder = new CqlBuilder(2048);
        this.appendCqlTo(builder, withInternals, withInternals, ifNotExists);
        return builder.toString();
    }

    public String toCqlString(boolean includeDroppedColumns, boolean internals, boolean ifNotExists) {
        CqlBuilder builder = new CqlBuilder(2048);
        this.appendCqlTo(builder, includeDroppedColumns, internals, ifNotExists);
        return builder.toString();
    }

    public void appendCqlTo(CqlBuilder builder, boolean includeDroppedColumns, boolean internals, boolean ifNotExists) {
        assert (!this.isView());
        String createKeyword = "CREATE";
        if (this.isVirtual()) {
            builder.append(String.format("/*\nWarning: Table %s is a virtual table and cannot be recreated with CQL.\nStructure, for reference:\n", this.toString()));
            createKeyword = "VIRTUAL";
        }
        builder.append(createKeyword).append(" TABLE ");
        if (ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.toString()).append(" (").newLine().increaseIndent();
        boolean hasSingleColumnPrimaryKey = this.partitionKeyColumns.size() == 1 && this.clusteringColumns.isEmpty();
        this.appendColumnDefinitions(builder, includeDroppedColumns, hasSingleColumnPrimaryKey);
        if (!hasSingleColumnPrimaryKey) {
            this.appendPrimaryKey(builder);
        }
        builder.decreaseIndent().append(')');
        builder.append(" WITH ").increaseIndent();
        this.appendTableOptions(builder, internals);
        builder.decreaseIndent();
        if (this.isVirtual()) {
            builder.newLine().append("*/");
        }
        if (includeDroppedColumns) {
            this.appendDropColumns(builder);
        }
    }

    private void appendColumnDefinitions(CqlBuilder builder, boolean includeDroppedColumns, boolean hasSingleColumnPrimaryKey) {
        Iterator<ColumnMetadata> iter = this.allColumnsInCreateOrder();
        while (iter.hasNext()) {
            ColumnMetadata column = iter.next();
            if (includeDroppedColumns && this.droppedColumns.containsKey((Object)column.name.bytes)) continue;
            column.appendCqlTo(builder);
            if (hasSingleColumnPrimaryKey && column.isPartitionKey()) {
                builder.append(" PRIMARY KEY");
            }
            if (!hasSingleColumnPrimaryKey || includeDroppedColumns && !this.droppedColumns.isEmpty() || iter.hasNext()) {
                builder.append(',');
            }
            builder.newLine();
        }
        if (includeDroppedColumns) {
            for (DroppedColumn dropped : this.droppedColumns.values()) {
                dropped.column.appendCqlTo(builder);
                if (!hasSingleColumnPrimaryKey || iter.hasNext()) {
                    builder.append(',');
                }
                builder.newLine();
            }
        }
    }

    void appendPrimaryKey(CqlBuilder builder) {
        ImmutableList<ColumnMetadata> partitionKeyColumns = this.partitionKeyColumns();
        Object clusteringColumns = this.clusteringColumns();
        if (this.isStaticCompactTable()) {
            clusteringColumns = Collections.emptyList();
        }
        builder.append("PRIMARY KEY (");
        if (partitionKeyColumns.size() > 1) {
            builder.append('(').appendWithSeparators(partitionKeyColumns, (b, c) -> b.append(c.name), ", ").append(')');
        } else {
            builder.append(((ColumnMetadata)partitionKeyColumns.get((int)0)).name);
        }
        if (!clusteringColumns.isEmpty()) {
            builder.append(", ").appendWithSeparators(clusteringColumns, (b, c) -> b.append(c.name), ", ");
        }
        builder.append(')').newLine();
    }

    void appendTableOptions(CqlBuilder builder, boolean internals) {
        ImmutableList<ColumnMetadata> clusteringColumns;
        if (internals) {
            builder.append("ID = ").append(this.id.toString()).newLine().append("AND ");
        }
        if (!(clusteringColumns = this.clusteringColumns()).isEmpty()) {
            builder.append("CLUSTERING ORDER BY (").appendWithSeparators(clusteringColumns, (b, c) -> c.appendNameAndOrderTo(b), ", ").append(')').newLine().append("AND ");
        }
        if (this.isVirtual()) {
            builder.append("comment = ").appendWithSingleQuotes(this.params.comment);
        } else {
            this.params.appendCqlTo(builder);
        }
        builder.append(";");
    }

    private void appendDropColumns(CqlBuilder builder) {
        for (Map.Entry entry : this.droppedColumns.entrySet()) {
            DroppedColumn dropped = (DroppedColumn)entry.getValue();
            builder.newLine().append("ALTER TABLE ").append(this.toString()).append(" DROP ").append(dropped.column.name).append(" USING TIMESTAMP ").append(dropped.droppedTime).append(';');
            ColumnMetadata column = this.getColumn((ByteBuffer)entry.getKey());
            if (column == null) continue;
            builder.newLine().append("ALTER TABLE ").append(this.toString()).append(" ADD ");
            column.appendCqlTo(builder);
            builder.append(';');
        }
    }

    public static class CompactTableMetadata
    extends TableMetadata {
        public final ColumnMetadata compactValueColumn;
        private final Set<ColumnMetadata> hiddenColumns;

        protected CompactTableMetadata(Builder builder) {
            super(builder);
            this.compactValueColumn = CompactTableMetadata.getCompactValueColumn(this.regularAndStaticColumns);
            if (this.isCompactTable() && Flag.isDense((Set<Flag>)this.flags) && this.hasEmptyCompactValue()) {
                this.hiddenColumns = Collections.singleton(this.compactValueColumn);
            } else if (this.isCompactTable() && !Flag.isDense((Set<Flag>)this.flags)) {
                this.hiddenColumns = Sets.newHashSetWithExpectedSize((int)(this.clusteringColumns.size() + 1));
                this.hiddenColumns.add(this.compactValueColumn);
                this.hiddenColumns.addAll((Collection<ColumnMetadata>)this.clusteringColumns);
            } else {
                this.hiddenColumns = Collections.emptySet();
            }
        }

        @Override
        public boolean isCompactTable() {
            return true;
        }

        @Override
        public ColumnMetadata getExistingColumn(ColumnIdentifier name) {
            ColumnMetadata def = this.getColumn(name);
            if (def == null || this.isHiddenColumn(def)) {
                throw new InvalidRequestException(String.format("Undefined column name %s in table %s", name.toCQLString(), this));
            }
            return def;
        }

        public boolean isHiddenColumn(ColumnMetadata def) {
            return this.hiddenColumns.contains(def);
        }

        @Override
        public Iterator<ColumnMetadata> allColumnsInSelectOrder() {
            UnmodifiableIterator clusteringIter;
            boolean isStaticCompactTable = this.isStaticCompactTable();
            boolean noNonPkColumns = this.hasEmptyCompactValue();
            UnmodifiableIterator partitionKeyIter = this.partitionKeyColumns.iterator();
            UnmodifiableIterator unmodifiableIterator = clusteringIter = isStaticCompactTable ? Collections.emptyIterator() : this.clusteringColumns.iterator();
            Iterator otherColumns = noNonPkColumns ? Collections.emptyIterator() : (isStaticCompactTable ? this.staticColumns().selectOrderIterator() : this.regularAndStaticColumns.selectOrderIterator());
            return TableMetadata.columnsIterator((Iterator)partitionKeyIter, (Iterator)clusteringIter, otherColumns);
        }

        public ImmutableList<ColumnMetadata> createStatementClusteringColumns() {
            return this.isStaticCompactTable() ? ImmutableList.of() : this.clusteringColumns;
        }

        @Override
        public Iterator<ColumnMetadata> allColumnsInCreateOrder() {
            Iterator<Object> otherColumns;
            boolean isStaticCompactTable = this.isStaticCompactTable();
            boolean noNonPkColumns = !Flag.isCQLTable((Set<Flag>)this.flags) && this.hasEmptyCompactValue();
            UnmodifiableIterator partitionKeyIter = this.partitionKeyColumns.iterator();
            UnmodifiableIterator clusteringIter = this.isStaticCompactTable() ? Collections.EMPTY_LIST.iterator() : this.createStatementClusteringColumns().iterator();
            if (noNonPkColumns) {
                otherColumns = Collections.emptyIterator();
            } else if (isStaticCompactTable) {
                ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
                for (ColumnMetadata c : this.regularAndStaticColumns) {
                    if (!c.isStatic()) continue;
                    columns.add(new ColumnMetadata(c.ksName, c.cfName, c.name, c.type, -1, ColumnMetadata.Kind.REGULAR));
                }
                otherColumns = columns.iterator();
            } else {
                otherColumns = this.regularAndStaticColumns.iterator();
            }
            return TableMetadata.columnsIterator((Iterator)partitionKeyIter, (Iterator)clusteringIter, otherColumns);
        }

        public boolean hasEmptyCompactValue() {
            return this.compactValueColumn.type instanceof EmptyType;
        }

        @Override
        public void validate() {
            super.validate();
            if (!Flag.isCQLTable((Set<Flag>)this.flags) && this.clusteringColumns.isEmpty()) {
                this.except("For table %s, isDense=%b, isCompound=%b, clustering=%s", this.toString(), Flag.isDense((Set<Flag>)this.flags), Flag.isCompound((Set<Flag>)this.flags), this.clusteringColumns);
            }
        }

        AbstractType<?> staticCompactOrSuperTableColumnNameType() {
            assert (this.isStaticCompactTable());
            return ((ColumnMetadata)this.clusteringColumns.get((int)0)).type;
        }

        public AbstractType<?> columnDefinitionNameComparator(ColumnMetadata.Kind kind) {
            return Flag.isSuper((Set<Flag>)this.flags) && kind == ColumnMetadata.Kind.REGULAR || this.isStaticCompactTable() && kind == ColumnMetadata.Kind.STATIC ? this.staticCompactOrSuperTableColumnNameType() : UTF8Type.instance;
        }

        @Override
        public boolean isStaticCompactTable() {
            return !Flag.isSuper((Set<Flag>)this.flags) && !Flag.isDense((Set<Flag>)this.flags) && !Flag.isCompound((Set<Flag>)this.flags);
        }

        @Override
        public void appendCqlTo(CqlBuilder builder, boolean includeDroppedColumns, boolean internals, boolean ifNotExists) {
            builder.append("/*").newLine().append("Warning: Table ").append(this.toString()).append(" omitted because it has constructs not compatible with CQL (was created via legacy API).").newLine().append("Approximate structure, for reference:").newLine().append("(this should not be used to reproduce this schema)").newLine().newLine();
            super.appendCqlTo(builder, includeDroppedColumns, internals, ifNotExists);
            builder.newLine().append("*/");
        }

        @Override
        void appendTableOptions(CqlBuilder builder, boolean internals) {
            builder.append("COMPACT STORAGE").newLine().append("AND ");
            super.appendTableOptions(builder, internals);
        }

        public static ColumnMetadata getCompactValueColumn(RegularAndStaticColumns columns) {
            assert (columns.regulars.simpleColumnCount() == 1 && columns.regulars.complexColumnCount() == 0);
            return columns.regulars.getSimple(0);
        }
    }

    public static final class Builder {
        final String keyspace;
        final String name;
        private TableId id;
        private IPartitioner partitioner;
        private Kind kind = Kind.REGULAR;
        private TableParams.Builder params = TableParams.builder();
        private Set<Flag> flags = EnumSet.of(Flag.COMPOUND);
        private Triggers triggers = Triggers.none();
        private Indexes indexes = Indexes.none();
        private final Map<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
        private final Map<ByteBuffer, ColumnMetadata> columns = new HashMap<ByteBuffer, ColumnMetadata>();
        private final List<ColumnMetadata> partitionKeyColumns = new ArrayList<ColumnMetadata>();
        private final List<ColumnMetadata> clusteringColumns = new ArrayList<ColumnMetadata>();
        private final List<ColumnMetadata> regularAndStaticColumns = new ArrayList<ColumnMetadata>();

        private Builder(String keyspace, String name, TableId id) {
            this.keyspace = keyspace;
            this.name = name;
            this.id = id;
        }

        private Builder(String keyspace, String name) {
            this.keyspace = keyspace;
            this.name = name;
        }

        public TableMetadata build() {
            if (this.partitioner == null) {
                this.partitioner = DatabaseDescriptor.getPartitioner();
            }
            if (this.id == null) {
                this.id = TableId.generate();
            }
            if (Flag.isCQLTable(this.flags)) {
                return new TableMetadata(this);
            }
            return new CompactTableMetadata(this);
        }

        public Builder id(TableId val) {
            this.id = val;
            return this;
        }

        public Builder partitioner(IPartitioner val) {
            this.partitioner = val;
            return this;
        }

        public Builder kind(Kind val) {
            this.kind = val;
            return this;
        }

        public Builder params(TableParams val) {
            this.params = val.unbuild();
            return this;
        }

        public Builder bloomFilterFpChance(double val) {
            this.params.bloomFilterFpChance(val);
            return this;
        }

        public Builder caching(CachingParams val) {
            this.params.caching(val);
            return this;
        }

        public Builder comment(String val) {
            this.params.comment(val);
            return this;
        }

        public Builder compaction(CompactionParams val) {
            this.params.compaction(val);
            return this;
        }

        public Builder compression(CompressionParams val) {
            this.params.compression(val);
            return this;
        }

        public Builder defaultTimeToLive(int val) {
            this.params.defaultTimeToLive(val);
            return this;
        }

        public Builder gcGraceSeconds(int val) {
            this.params.gcGraceSeconds(val);
            return this;
        }

        public Builder maxIndexInterval(int val) {
            this.params.maxIndexInterval(val);
            return this;
        }

        public Builder memtableFlushPeriod(int val) {
            this.params.memtableFlushPeriodInMs(val);
            return this;
        }

        public Builder minIndexInterval(int val) {
            this.params.minIndexInterval(val);
            return this;
        }

        public Builder crcCheckChance(double val) {
            this.params.crcCheckChance(val);
            return this;
        }

        public Builder speculativeRetry(SpeculativeRetryPolicy val) {
            this.params.speculativeRetry(val);
            return this;
        }

        public Builder additionalWritePolicy(SpeculativeRetryPolicy val) {
            this.params.additionalWritePolicy(val);
            return this;
        }

        public Builder extensions(Map<String, ByteBuffer> val) {
            this.params.extensions(val);
            return this;
        }

        public Builder flags(Set<Flag> val) {
            this.flags = val;
            return this;
        }

        public Builder isCounter(boolean val) {
            return this.flag(Flag.COUNTER, val);
        }

        private Builder flag(Flag flag, boolean set) {
            if (set) {
                this.flags.add(flag);
            } else {
                this.flags.remove((Object)flag);
            }
            return this;
        }

        public Builder triggers(Triggers val) {
            this.triggers = val;
            return this;
        }

        public Builder indexes(Indexes val) {
            this.indexes = val;
            return this;
        }

        public Builder addPartitionKeyColumn(String name, AbstractType type) {
            return this.addPartitionKeyColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addPartitionKeyColumn(ColumnIdentifier name, AbstractType type) {
            return this.addColumn(new ColumnMetadata(this.keyspace, this.name, name, type, this.partitionKeyColumns.size(), ColumnMetadata.Kind.PARTITION_KEY));
        }

        public Builder addClusteringColumn(String name, AbstractType type) {
            return this.addClusteringColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addClusteringColumn(ColumnIdentifier name, AbstractType type) {
            return this.addColumn(new ColumnMetadata(this.keyspace, this.name, name, type, this.clusteringColumns.size(), ColumnMetadata.Kind.CLUSTERING));
        }

        public Builder addRegularColumn(String name, AbstractType type) {
            return this.addRegularColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addRegularColumn(ColumnIdentifier name, AbstractType type) {
            return this.addColumn(new ColumnMetadata(this.keyspace, this.name, name, type, -1, ColumnMetadata.Kind.REGULAR));
        }

        public Builder addStaticColumn(String name, AbstractType type) {
            return this.addStaticColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addStaticColumn(ColumnIdentifier name, AbstractType type) {
            return this.addColumn(new ColumnMetadata(this.keyspace, this.name, name, type, -1, ColumnMetadata.Kind.STATIC));
        }

        public Builder addColumn(ColumnMetadata column) {
            if (this.columns.containsKey(column.name.bytes)) {
                throw new IllegalArgumentException();
            }
            switch (column.kind) {
                case PARTITION_KEY: {
                    this.partitionKeyColumns.add(column);
                    Collections.sort(this.partitionKeyColumns);
                    break;
                }
                case CLUSTERING: {
                    column.type.checkComparable();
                    this.clusteringColumns.add(column);
                    Collections.sort(this.clusteringColumns);
                    break;
                }
                default: {
                    this.regularAndStaticColumns.add(column);
                }
            }
            this.columns.put(column.name.bytes, column);
            return this;
        }

        public Builder addColumns(Iterable<ColumnMetadata> columns) {
            columns.forEach(this::addColumn);
            return this;
        }

        public Builder droppedColumns(Map<ByteBuffer, DroppedColumn> droppedColumns) {
            this.droppedColumns.clear();
            this.droppedColumns.putAll(droppedColumns);
            return this;
        }

        public Builder recordDeprecatedSystemColumn(String name, AbstractType<?> type) {
            assert (SchemaConstants.isLocalSystemKeyspace(this.keyspace));
            this.recordColumnDrop(ColumnMetadata.regularColumn(this.keyspace, this.name, name, type), Long.MAX_VALUE);
            return this;
        }

        public Builder recordColumnDrop(ColumnMetadata column, long timeMicros) {
            this.droppedColumns.put(column.name.bytes, new DroppedColumn(column.withNewType(column.type.expandUserTypes()), timeMicros));
            return this;
        }

        public Iterable<ColumnMetadata> columns() {
            return this.columns.values();
        }

        public Set<String> columnNames() {
            return this.columns.values().stream().map(c -> c.name.toString()).collect(Collectors.toSet());
        }

        public ColumnMetadata getColumn(ColumnIdentifier identifier) {
            return this.columns.get(identifier.bytes);
        }

        public ColumnMetadata getColumn(ByteBuffer name) {
            return this.columns.get(name);
        }

        public boolean hasRegularColumns() {
            return this.regularAndStaticColumns.stream().anyMatch(ColumnMetadata::isRegular);
        }

        public Builder removeRegularOrStaticColumn(ColumnIdentifier identifier) {
            ColumnMetadata column = this.columns.get(identifier.bytes);
            if (column == null || column.isPrimaryKeyColumn()) {
                throw new IllegalArgumentException();
            }
            this.columns.remove(identifier.bytes);
            this.regularAndStaticColumns.remove(column);
            return this;
        }

        public Builder renamePrimaryKeyColumn(ColumnIdentifier from, ColumnIdentifier to) {
            if (this.columns.containsKey(to.bytes)) {
                throw new IllegalArgumentException();
            }
            ColumnMetadata column = this.columns.get(from.bytes);
            if (column == null || !column.isPrimaryKeyColumn()) {
                throw new IllegalArgumentException();
            }
            ColumnMetadata newColumn = column.withNewName(to);
            if (column.isPartitionKey()) {
                this.partitionKeyColumns.set(column.position(), newColumn);
            } else {
                this.clusteringColumns.set(column.position(), newColumn);
            }
            this.columns.remove(from.bytes);
            this.columns.put(to.bytes, newColumn);
            return this;
        }

        Builder alterColumnType(ColumnIdentifier name, AbstractType<?> type) {
            ColumnMetadata column = this.columns.get(name.bytes);
            if (column == null) {
                throw new IllegalArgumentException();
            }
            ColumnMetadata newColumn = column.withNewType(type);
            switch (column.kind) {
                case PARTITION_KEY: {
                    this.partitionKeyColumns.set(column.position(), newColumn);
                    break;
                }
                case CLUSTERING: {
                    this.clusteringColumns.set(column.position(), newColumn);
                    break;
                }
                case REGULAR: 
                case STATIC: {
                    this.regularAndStaticColumns.remove(column);
                    this.regularAndStaticColumns.add(newColumn);
                }
            }
            this.columns.put(column.name.bytes, newColumn);
            return this;
        }
    }

    public static enum Kind {
        REGULAR,
        INDEX,
        VIEW,
        VIRTUAL;

    }

    public static enum Flag {
        COMPOUND,
        DENSE,
        COUNTER,
        SUPER;


        public static boolean isDense(Set<Flag> flags) {
            return flags.contains((Object)DENSE);
        }

        public static boolean isCompound(Set<Flag> flags) {
            return flags.contains((Object)COMPOUND);
        }

        public static boolean isSuper(Set<Flag> flags) {
            return flags.contains((Object)SUPER);
        }

        public static boolean isCQLTable(Set<Flag> flags) {
            return !Flag.isSuper(flags) && !Flag.isDense(flags) && Flag.isCompound(flags);
        }

        public static boolean isStaticCompactTable(Set<Flag> flags) {
            return !Flag.isSuper(flags) && !Flag.isDense(flags) && !Flag.isCompound(flags);
        }

        public static Set<Flag> fromStringSet(Set<String> strings) {
            return strings.stream().map(String::toUpperCase).map(Flag::valueOf).collect(Collectors.toSet());
        }

        public static Set<String> toStringSet(Set<Flag> flags) {
            return flags.stream().map(Enum::toString).map(String::toLowerCase).collect(Collectors.toSet());
        }
    }
}

