/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.DebeziumException;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.AbstractDirectoryWatcher;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.Cassandra4CommitLogReadHandlerImpl;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.CommitLogUtil;
import io.debezium.connector.cassandra.EOFEvent;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.RecordMaker;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.CommitLogReadHandler;
import org.apache.cassandra.db.commitlog.CommitLogReader;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra4CommitLogProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cassandra4CommitLogProcessor.class);
    private static final String NAME = "Commit Log Processor";
    private final CassandraConnectorContext context;
    private final File cdcDir;
    private AbstractDirectoryWatcher watcher;
    private final List<ChangeEventQueue<Event>> queues;
    private final CommitLogProcessorMetrics metrics = new CommitLogProcessorMetrics();
    private boolean initial = true;
    private final boolean errorCommitLogReprocessEnabled;
    private final CommitLogTransfer commitLogTransfer;
    private final ExecutorService executorService;
    static final Set<Pair<CommitLogProcessingCallable, Future<ProcessingResult>>> submittedProcessings = ConcurrentHashMap.newKeySet();

    public Cassandra4CommitLogProcessor(CassandraConnectorContext context) {
        super(NAME, Duration.ZERO);
        this.context = context;
        this.executorService = Executors.newSingleThreadExecutor();
        this.queues = this.context.getQueues();
        this.commitLogTransfer = this.context.getCassandraConnectorConfig().getCommitLogTransfer();
        this.errorCommitLogReprocessEnabled = this.context.getCassandraConnectorConfig().errorCommitLogReprocessEnabled();
        this.cdcDir = new File(DatabaseDescriptor.getCDCLogLocation());
    }

    public void initialize() {
        this.metrics.registerMetrics();
    }

    public void destroy() {
        this.metrics.unregisterMetrics();
    }

    public void stop() {
        try {
            this.executorService.shutdown();
            for (Pair<CommitLogProcessingCallable, Future<ProcessingResult>> submittedProcessing : submittedProcessings) {
                try {
                    ((CommitLogProcessingCallable)submittedProcessing.getFirst()).complete();
                    ((Future)submittedProcessing.getSecond()).get();
                }
                catch (Exception ex) {
                    LOGGER.warn("Waiting for submitted task to finish has failed.");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to close executor service in CommitLogProcessor in a timely manner");
        }
        super.stop();
    }

    private void submit(Path index) {
        CommitLogProcessingCallable callable = new CommitLogProcessingCallable(new LogicalCommitLog(index.toFile()), this.queues, this.metrics, this.context);
        Future<ProcessingResult> future = this.executorService.submit(callable);
        submittedProcessings.add((Pair<CommitLogProcessingCallable, Future<ProcessingResult>>)new Pair((Object)callable, future));
    }

    public boolean isRunning() {
        return super.isRunning() && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    public void process() throws IOException, InterruptedException {
        LOGGER.debug("Processing commitLogFiles while initial is {}", (Object)this.initial);
        if (this.watcher == null) {
            this.watcher = new AbstractDirectoryWatcher(this.cdcDir.toPath(), this.context.getCassandraConnectorConfig().cdcDirPollInterval(), Collections.singleton(StandardWatchEventKinds.ENTRY_CREATE)){

                void handleEvent(WatchEvent<?> event, Path path) {
                    if (Cassandra4CommitLogProcessor.this.isRunning() && path.getFileName().toString().endsWith("_cdc.idx")) {
                        Cassandra4CommitLogProcessor.this.submit(path);
                    }
                }
            };
        }
        if (this.initial) {
            LOGGER.info("Reading existing commit logs in {}", (Object)this.cdcDir);
            File[] indexes = CommitLogUtil.getIndexes((File)this.cdcDir);
            Arrays.sort(indexes, CommitLogUtil::compareCommitLogsIndexes);
            for (File index : indexes) {
                if (!this.isRunning()) continue;
                this.submit(index.toPath());
            }
            if (this.errorCommitLogReprocessEnabled) {
                LOGGER.info("CommitLog Error Processing is enabled. Attempting to get all error commitLog files for re-processing.");
                this.commitLogTransfer.getErrorCommitLogFiles();
            }
            this.initial = false;
        }
        this.watcher.poll();
    }

    public static class LogicalCommitLog {
        CommitLogPosition commitLogPosition;
        File log;
        File index;
        long commitLogSegmentId;
        int offsetOfEndOfLastWrittenCDCMutation = 0;
        boolean completed = false;

        public LogicalCommitLog(File index) {
            this.index = index;
            this.log = LogicalCommitLog.parseCommitLogName(index);
            this.commitLogSegmentId = LogicalCommitLog.parseSegmentId(this.log);
            this.commitLogPosition = new CommitLogPosition(this.commitLogSegmentId, 0);
        }

        public static File parseCommitLogName(File index) {
            String newFileName = index.toPath().getFileName().toString().replace("_cdc.idx", ".log");
            return index.toPath().getParent().resolve(newFileName).toFile();
        }

        public static long parseSegmentId(File logName) {
            return Long.parseLong(logName.getName().split("-")[2].split("\\.")[0]);
        }

        public boolean exists() {
            return this.log.exists();
        }

        public void parseCommitLogIndex() throws DebeziumException {
            if (!this.index.exists()) {
                return;
            }
            try {
                List<String> lines = Files.readAllLines(this.index.toPath(), StandardCharsets.UTF_8);
                if (lines.isEmpty()) {
                    return;
                }
                this.offsetOfEndOfLastWrittenCDCMutation = Integer.parseInt(lines.get(0));
                if (lines.size() == 2) {
                    this.completed = "COMPLETED".equals(lines.get(1));
                }
            }
            catch (Exception ex) {
                throw new DebeziumException(String.format("Unable to parse commit log index file %s", this.index.toPath()), (Throwable)ex);
            }
        }

        public String toString() {
            return "LogicalCommitLog{commitLogPosition=" + this.commitLogPosition + ", synced=" + this.offsetOfEndOfLastWrittenCDCMutation + ", completed=" + this.completed + ", log=" + this.log + ", index=" + this.index + ", commitLogSegmentId=" + this.commitLogSegmentId + '}';
        }
    }

    public static class CommitLogProcessingCallable
    implements Callable<ProcessingResult> {
        private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogProcessingCallable.class);
        private final LogicalCommitLog commitLog;
        private CommitLogReader commitLogReader;
        private final List<ChangeEventQueue<Event>> queues;
        private final CommitLogProcessorMetrics metrics;
        private final Cassandra4CommitLogReadHandlerImpl commitLogReadHandler;
        private final CommitLogTransfer commitLogTransfer;
        private final Set<String> erroneousCommitLogs;
        private boolean completePrematurely = false;

        public CommitLogProcessingCallable(LogicalCommitLog commitLog, List<ChangeEventQueue<Event>> queues, CommitLogProcessorMetrics metrics, CassandraConnectorContext context) {
            this.commitLog = commitLog;
            this.commitLogReader = new CommitLogReader();
            this.queues = queues;
            this.metrics = metrics;
            this.commitLogReadHandler = new Cassandra4CommitLogReadHandlerImpl(context.getSchemaHolder(), context.getQueues(), context.getOffsetWriter(), new RecordMaker(context.getCassandraConnectorConfig().tombstonesOnDelete(), new Filters(context.getCassandraConnectorConfig().fieldExcludeList()), context.getCassandraConnectorConfig()), metrics);
            this.commitLogTransfer = context.getCassandraConnectorConfig().getCommitLogTransfer();
            this.erroneousCommitLogs = context.getErroneousCommitLogs();
        }

        public void complete() {
            this.completePrematurely = true;
        }

        private ProcessingResult callInternal() {
            ProcessingResult result;
            if (!this.commitLog.exists()) {
                LOGGER.warn("Commit log " + this.commitLog + " does not exist!");
                return new ProcessingResult(this.commitLog, ProcessingResult.Result.DOES_NOT_EXIST);
            }
            LOGGER.info("Processing commit log {}", (Object)this.commitLog.log.toString());
            CommitLogPosition position = new CommitLogPosition(this.commitLog.commitLogSegmentId, 0);
            this.metrics.setCommitLogFilename(this.commitLog.log.toString());
            this.metrics.setCommitLogPosition((long)position.position);
            try {
                this.parseIndexFile();
                while (!this.commitLog.completed) {
                    if (this.completePrematurely) {
                        LOGGER.info("{} completed prematurely", (Object)this.commitLog.toString());
                        return new ProcessingResult(this.commitLog, ProcessingResult.Result.COMPLETED_PREMATURELY);
                    }
                    Thread.sleep(10000L);
                    this.parseIndexFile();
                }
                LOGGER.info(this.commitLog.toString());
            }
            catch (Exception ex) {
                LOGGER.error("Processing of {} errored out", (Object)this.commitLog.toString());
                return new ProcessingResult(this.commitLog, ProcessingResult.Result.ERROR, ex);
            }
            try {
                this.processCommitLog(this.commitLog, new CommitLogPosition(this.commitLog.commitLogSegmentId, 0));
                result = new ProcessingResult(this.commitLog);
            }
            catch (Exception ex) {
                result = new ProcessingResult(this.commitLog, ProcessingResult.Result.ERROR, ex);
            }
            LOGGER.info("{}", (Object)result);
            return result;
        }

        @Override
        public ProcessingResult call() {
            ProcessingResult result = this.callInternal();
            submittedProcessings.remove(this);
            return result;
        }

        private void processCommitLog(LogicalCommitLog logicalCommitLog, CommitLogPosition position) {
            try {
                try {
                    this.commitLogReader.readCommitLogSegment((CommitLogReadHandler)this.commitLogReadHandler, logicalCommitLog.log, position, false);
                    this.queues.get(Math.abs(logicalCommitLog.log.getName().hashCode() % this.queues.size())).enqueue((Object)new EOFEvent(logicalCommitLog.log));
                }
                catch (Exception e) {
                    if (this.commitLogTransfer.getClass().getName().equals("io.debezium.connector.cassandra.BlackHoleCommitLogTransfer")) {
                        throw new DebeziumException(String.format("Error occurred while processing commit log %s", logicalCommitLog.log), (Throwable)e);
                    }
                    LOGGER.error("Error occurred while processing commit log " + logicalCommitLog.log, (Throwable)e);
                    this.queues.get(Math.abs(logicalCommitLog.log.getName().hashCode() % this.queues.size())).enqueue((Object)new EOFEvent(logicalCommitLog.log));
                    this.erroneousCommitLogs.add(logicalCommitLog.log.getName());
                }
            }
            catch (InterruptedException e) {
                throw new CassandraConnectorTaskException(String.format("Enqueuing has been interrupted while enqueuing EOF Event for file %s", logicalCommitLog.log.getName()), (Throwable)e);
            }
        }

        private void parseIndexFile() throws DebeziumException {
            try {
                this.commitLog.parseCommitLogIndex();
            }
            catch (DebeziumException ex) {
                this.erroneousCommitLogs.add(this.commitLog.log.getName());
                throw ex;
            }
        }
    }

    public static class ProcessingResult {
        public final LogicalCommitLog commitLog;
        public final Result result;
        public final Exception ex;

        public ProcessingResult(LogicalCommitLog commitLog) {
            this(commitLog, Result.OK, null);
        }

        public ProcessingResult(LogicalCommitLog commitLog, Result result) {
            this(commitLog, result, null);
        }

        public ProcessingResult(LogicalCommitLog commitLog, Result result, Exception ex) {
            this.commitLog = commitLog;
            this.result = result;
            this.ex = ex;
        }

        public String toString() {
            return "ProcessingResult{commitLog=" + this.commitLog + ", result=" + (Object)((Object)this.result) + ", ex=" + (this.ex != null ? this.ex.getMessage() : "none") + '}';
        }

        public static enum Result {
            OK,
            ERROR,
            DOES_NOT_EXIST,
            COMPLETED_PREMATURELY;

        }
    }
}

