/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class UserDefinedTypeDeserializer
implements TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        UserType userType = (UserType)abstractType;
        UserTypes.Value value = UserTypes.Value.fromSerialized((ByteBuffer)bb, (UserType)userType);
        List elements = value.getElements();
        Struct struct = new Struct(this.getSchemaBuilder(abstractType).build());
        for (int i = 0; i < userType.fieldNames().size(); ++i) {
            String fieldName = userType.fieldNameAsString(i);
            AbstractType fieldType = userType.type(i);
            struct.put(fieldName, CassandraTypeDeserializer.deserialize(fieldType, (ByteBuffer)elements.get(i)));
        }
        return struct;
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        UserType userType = (UserType)abstractType;
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(userType.keyspace + "." + userType.getNameAsString());
        List fieldIdentifiers = userType.fieldNames();
        List fieldTypes = userType.fieldTypes();
        for (int i = 0; i < fieldIdentifiers.size(); ++i) {
            Schema fieldSchema = CassandraTypeDeserializer.getSchemaBuilder((AbstractType)fieldTypes.get(i)).build();
            schemaBuilder.field(((FieldIdentifier)fieldIdentifiers.get(i)).toString(), fieldSchema);
        }
        return schemaBuilder.optional();
    }
}

