/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.util.Clock;
import io.debezium.util.ElapsedTimeStrategy;
import java.time.Duration;

public interface OffsetFlushPolicy {
    public boolean shouldFlush();

    public static OffsetFlushPolicy always() {
        return new AlwaysFlushOffsetPolicy();
    }

    public static OffsetFlushPolicy periodic(Duration offsetFlushInterval, long maxOffsetFlushSize) {
        return new PeriodicFlushOffsetPolicy(offsetFlushInterval, maxOffsetFlushSize);
    }

    public static class AlwaysFlushOffsetPolicy
    implements OffsetFlushPolicy {
        @Override
        public boolean shouldFlush() {
            return true;
        }
    }

    public static class PeriodicFlushOffsetPolicy
    implements OffsetFlushPolicy {
        private final long maxOffsetFlushSize;
        private long unflushedRecordCount;
        private final ElapsedTimeStrategy elapsedTimeStrategy;

        PeriodicFlushOffsetPolicy(Duration offsetFlushInterval, long maxOffsetFlushSize) {
            this.maxOffsetFlushSize = maxOffsetFlushSize;
            this.unflushedRecordCount = 0L;
            this.elapsedTimeStrategy = ElapsedTimeStrategy.constant((Clock)Clock.system(), (Duration)offsetFlushInterval);
        }

        @Override
        public boolean shouldFlush() {
            if (this.unflushedRecordCount >= this.maxOffsetFlushSize) {
                this.clear();
                return true;
            }
            if (this.elapsedTimeStrategy.hasElapsed()) {
                this.clear();
                return true;
            }
            ++this.unflushedRecordCount;
            return false;
        }

        private void clear() {
            this.unflushedRecordCount = 0L;
        }
    }
}

