/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.ComponentFactory;
import io.debezium.connector.cassandra.Emitter;
import io.debezium.connector.cassandra.FileOffsetWriter;
import io.debezium.connector.cassandra.KafkaRecordEmitter;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import java.io.IOException;
import org.apache.kafka.clients.producer.KafkaProducer;

public class ComponentFactoryStandalone
implements ComponentFactory {
    @Override
    public OffsetWriter offsetWriter(CassandraConnectorConfig config) {
        try {
            return new FileOffsetWriter(config);
        }
        catch (IOException e) {
            throw new CassandraConnectorConfigException(String.format("cannot create file offset writer into %s", config.offsetBackingStoreDir()), e);
        }
    }

    @Override
    public Emitter recordEmitter(CassandraConnectorContext context) {
        CassandraConnectorConfig config = context.getCassandraConnectorConfig();
        return new KafkaRecordEmitter(config, (KafkaProducer<byte[], byte[]>)new KafkaProducer(config.getKafkaConfigs()), context.getOffsetWriter(), config.getKeyConverter(), config.getValueConverter(), context.getErroneousCommitLogs(), config.getCommitLogTransfer());
    }
}

