/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractTupleTypeDeserializer
extends AbstractTypeDeserializer {
    private static final String TUPLE_NAME_POSTFIX = "Tuple";
    private static final String FIELD_NAME_PREFIX = "field";

    public AbstractTupleTypeDeserializer(DebeziumTypeDeserializer deserializer, Integer dataType, Class<?> abstractTypeClass) {
        super(deserializer, dataType, abstractTypeClass);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        List<?> innerTypes = this.allTypes(abstractType);
        ByteBuffer[] innerValueByteBuffers = this.split(abstractType, bb);
        Struct struct = new Struct(this.getSchemaBuilder(abstractType).build());
        for (int i = 0; i < innerTypes.size(); ++i) {
            Object currentInnerType = innerTypes.get(i);
            String fieldName = this.createFieldNameForIndex(i);
            Object deserializedInnerObject = CassandraTypeDeserializer.deserialize(currentInnerType, innerValueByteBuffers[i]);
            struct.put(fieldName, deserializedInnerObject);
        }
        return struct;
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        List<?> tupleInnerTypes = this.allTypes(abstractType);
        String recordName = this.createTupleName(tupleInnerTypes);
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(recordName);
        for (int i = 0; i < tupleInnerTypes.size(); ++i) {
            Object innerType = tupleInnerTypes.get(i);
            schemaBuilder.field(this.createFieldNameForIndex(i), CassandraTypeDeserializer.getSchemaBuilder(innerType).build());
        }
        return schemaBuilder.optional();
    }

    private String createTupleName(List<?> innerTypes) {
        StringBuilder tupleNameBuilder = new StringBuilder();
        for (Object innerType : innerTypes) {
            tupleNameBuilder.append(this.abstractTypeToNiceString(innerType));
        }
        return tupleNameBuilder.append(TUPLE_NAME_POSTFIX).toString();
    }

    private String createFieldNameForIndex(int i) {
        return FIELD_NAME_PREFIX + (i + 1);
    }

    private String abstractTypeToNiceString(Object tupleInnerType) {
        String typeName = tupleInnerType.getClass().getSimpleName();
        return typeName.substring(0, typeName.length() - 4);
    }

    @Override
    public Object getAbstractType(DataType dataType) {
        DefaultTupleType tupleType = (DefaultTupleType)dataType;
        List innerTypes = tupleType.getComponentTypes();
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(innerTypes.size());
        for (DataType dt : innerTypes) {
            Object innerAbstractType = CassandraTypeDeserializer.getTypeDeserializer(dt).getAbstractType(dt);
            innerAbstractTypes.add(innerAbstractType);
        }
        return this.getAbstractTypeInstance(innerAbstractTypes);
    }

    protected abstract List<?> allTypes(Object var1);

    protected abstract ByteBuffer[] split(Object var1, ByteBuffer var2);

    protected abstract Object getAbstractTypeInstance(List<?> var1);
}

