/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.CommitLogUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CommitLogPostProcessor
extends AbstractProcessor {
    private static final String NAME = "Commit Log Post-Processor";
    private static final int THREAD_POOL_SIZE = 10;
    private static final int TERMINATION_WAIT_TIME_SECONDS = 10;
    private final ExecutorService executor;
    private final String commitLogRelocationDir;
    private final CommitLogTransfer commitLogTransfer;

    public CommitLogPostProcessor(CassandraConnectorConfig config) {
        super(NAME, config.commitLogRelocationDirPollInterval());
        this.commitLogRelocationDir = config.commitLogRelocationDir();
        this.executor = Executors.newFixedThreadPool(10);
        this.commitLogTransfer = config.getCommitLogTransfer();
    }

    @Override
    public void process() {
        File[] commitLogs = CommitLogUtil.getCommitLogs(Paths.get(this.commitLogRelocationDir, "archive").toFile());
        Arrays.sort(commitLogs, CommitLogUtil::compareCommitLogs);
        for (File commitLog : commitLogs) {
            if (!this.isRunning()) continue;
            this.executor.submit(() -> this.commitLogTransfer.onSuccessTransfer(commitLog));
        }
        File[] errCommitLogs = CommitLogUtil.getCommitLogs(Paths.get(this.commitLogRelocationDir, "error").toFile());
        Arrays.sort(errCommitLogs, CommitLogUtil::compareCommitLogs);
        for (File errCommitLog : errCommitLogs) {
            if (!this.isRunning()) continue;
            this.executor.submit(() -> this.commitLogTransfer.onErrorTransfer(errCommitLog));
        }
    }

    @Override
    public void destroy() throws Exception {
        this.shutDown(true);
        this.commitLogTransfer.destroy();
    }

    void shutDown(boolean await) {
        block4: {
            try {
                if (!this.executor.isShutdown()) {
                    boolean terminated;
                    this.executor.shutdown();
                    if (await && !(terminated = this.executor.awaitTermination(10L, TimeUnit.SECONDS))) {
                        this.executor.shutdownNow();
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.executor.isTerminated()) break block4;
                this.executor.shutdownNow();
            }
        }
    }
}

