/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.Record;
import io.debezium.data.Envelope;
import io.debezium.transforms.SmtManager;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;

public class EnvelopeTransformation<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private SmtManager<R> smtManager;

    public R apply(R record) {
        Envelope.Operation op;
        if (record.value() == null || !this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        Struct originalValueStruct = (Struct)record.value();
        String operation = originalValueStruct.getString("op");
        if (Record.Operation.INSERT.getValue().equals(operation)) {
            op = Envelope.Operation.CREATE;
        } else if (Record.Operation.UPDATE.getValue().equals(operation)) {
            op = Envelope.Operation.UPDATE;
        } else if (Record.Operation.DELETE.getValue().equals(operation)) {
            op = Envelope.Operation.DELETE;
        } else if (Record.Operation.RANGE_TOMBSTONE.getValue().equals(operation)) {
            op = Envelope.Operation.TRUNCATE;
        } else {
            return record;
        }
        Struct updatedValueStruct = originalValueStruct.put("op", (Object)op.code());
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), (Object)updatedValueStruct, record.timestamp());
    }

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        this.smtManager = new SmtManager(config);
    }

    public String version() {
        return Module.version();
    }
}

