/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.UnfilteredDeserializer;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RewindableDataInput;
import org.apache.cassandra.utils.AbstractIterator;

public abstract class SSTableSimpleIterator
extends AbstractIterator<Unfiltered>
implements Iterator<Unfiltered> {
    protected final CFMetaData metadata;
    protected final DataInputPlus in;
    protected final SerializationHelper helper;

    private SSTableSimpleIterator(CFMetaData metadata, DataInputPlus in, SerializationHelper helper) {
        this.metadata = metadata;
        this.in = in;
        this.helper = helper;
    }

    public static SSTableSimpleIterator create(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper, DeletionTime partitionDeletion) {
        if (helper.version < 10) {
            return new OldFormatIterator(metadata, in, helper, partitionDeletion);
        }
        return new CurrentFormatIterator(metadata, in, header, helper);
    }

    public static SSTableSimpleIterator createTombstoneOnly(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper, DeletionTime partitionDeletion) {
        if (helper.version < 10) {
            return new OldFormatTombstoneIterator(metadata, in, helper, partitionDeletion);
        }
        return new CurrentFormatTombstoneIterator(metadata, in, header, helper);
    }

    public abstract Row readStaticRow() throws IOException;

    private static class OldFormatTombstoneIterator
    extends OldFormatIterator {
        private OldFormatTombstoneIterator(CFMetaData metadata, DataInputPlus in, SerializationHelper helper, DeletionTime partitionDeletion) {
            super(metadata, in, helper, partitionDeletion);
        }

        @Override
        public Row readStaticRow() throws IOException {
            Row row = super.readStaticRow();
            if (!row.deletion().isLive()) {
                return BTreeRow.emptyDeletedRow(row.clustering(), row.deletion());
            }
            return Rows.EMPTY_STATIC_ROW;
        }

        @Override
        protected Unfiltered computeNext() {
            Unfiltered unfiltered;
            Row row;
            do {
                if ((unfiltered = super.computeNext()) != null && !unfiltered.isRangeTombstoneMarker()) continue;
                return unfiltered;
            } while ((row = (Row)unfiltered).deletion().isLive());
            return BTreeRow.emptyDeletedRow(row.clustering(), row.deletion());
        }
    }

    private static class OldFormatIterator
    extends SSTableSimpleIterator {
        private final UnfilteredDeserializer deserializer;

        private OldFormatIterator(CFMetaData metadata, DataInputPlus in, SerializationHelper helper, DeletionTime partitionDeletion) {
            super(metadata, in, helper);
            this.deserializer = UnfilteredDeserializer.create(metadata, in, null, helper, partitionDeletion, false);
        }

        @Override
        public Row readStaticRow() throws IOException {
            if (this.metadata.isCompactTable()) {
                if (this.metadata.isStaticCompactTable()) {
                    assert (this.in instanceof RewindableDataInput);
                    RewindableDataInput file = (RewindableDataInput)this.in;
                    DataPosition mark = file.mark();
                    Row staticRow = LegacyLayout.extractStaticColumns(this.metadata, file, this.metadata.partitionColumns().statics);
                    file.reset(mark);
                    ((UnfilteredDeserializer.OldFormatDeserializer)this.deserializer).setSkipStatic();
                    return staticRow;
                }
                return Rows.EMPTY_STATIC_ROW;
            }
            return this.deserializer.hasNext() && this.deserializer.nextIsStatic() ? (Row)this.deserializer.readNext() : Rows.EMPTY_STATIC_ROW;
        }

        @Override
        protected Unfiltered computeNext() {
            try {
                Row row;
                ColumnDefinition def;
                Unfiltered unfiltered;
                do {
                    if (!this.deserializer.hasNext()) {
                        return (Unfiltered)this.endOfData();
                    }
                    unfiltered = this.deserializer.readNext();
                } while (this.metadata.isStaticCompactTable() && unfiltered.kind() == Unfiltered.Kind.ROW && (def = this.metadata.getColumnDefinition(LegacyLayout.encodeClustering(this.metadata, (row = (Row)unfiltered).clustering()))) != null && def.isStatic());
                return unfiltered;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private static class CurrentFormatTombstoneIterator
    extends SSTableSimpleIterator {
        private final SerializationHeader header;

        private CurrentFormatTombstoneIterator(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
            super(metadata, in, helper);
            this.header = header;
        }

        @Override
        public Row readStaticRow() throws IOException {
            Row staticRow;
            if (this.header.hasStatic() && !(staticRow = UnfilteredSerializer.serializer.deserializeStaticRow(this.in, this.header, this.helper)).deletion().isLive()) {
                return BTreeRow.emptyDeletedRow(staticRow.clustering(), staticRow.deletion());
            }
            return Rows.EMPTY_STATIC_ROW;
        }

        @Override
        protected Unfiltered computeNext() {
            try {
                Unfiltered unfiltered = UnfilteredSerializer.serializer.deserializeTombstonesOnly((FileDataInput)this.in, this.header, this.helper);
                return unfiltered == null ? (Unfiltered)this.endOfData() : unfiltered;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private static class CurrentFormatIterator
    extends SSTableSimpleIterator {
        private final SerializationHeader header;
        private final Row.Builder builder;

        private CurrentFormatIterator(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
            super(metadata, in, helper);
            this.header = header;
            this.builder = BTreeRow.sortedBuilder();
        }

        @Override
        public Row readStaticRow() throws IOException {
            return this.header.hasStatic() ? UnfilteredSerializer.serializer.deserializeStaticRow(this.in, this.header, this.helper) : Rows.EMPTY_STATIC_ROW;
        }

        @Override
        protected Unfiltered computeNext() {
            try {
                Unfiltered unfiltered = UnfilteredSerializer.serializer.deserialize(this.in, this.header, this.helper, this.builder);
                return unfiltered == null ? (Unfiltered)this.endOfData() : unfiltered;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }
}

