/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.querybuilder.Literal;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultLiteral<ValueT>
implements Literal {
    private final ValueT value;
    private final TypeCodec<ValueT> codec;
    private final CqlIdentifier alias;

    public DefaultLiteral(@Nullable ValueT value, @Nullable TypeCodec<ValueT> codec) {
        this(value, codec, null);
    }

    public DefaultLiteral(@Nullable ValueT value, @Nullable TypeCodec<ValueT> codec, @Nullable CqlIdentifier alias) {
        Preconditions.checkArgument((value == null || codec != null ? 1 : 0) != 0, (Object)"Must provide a codec if the value is not null");
        this.value = value;
        this.codec = codec;
        this.alias = alias;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        if (this.value == null) {
            builder.append("NULL");
        } else {
            builder.append(this.codec.format(this.value));
        }
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new DefaultLiteral<ValueT>(this.value, this.codec, alias);
    }

    @Nullable
    public ValueT getValue() {
        return this.value;
    }

    @Nullable
    public TypeCodec<ValueT> getCodec() {
        return this.codec;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }
}

