/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.net.InetAddress;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptionOptions {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionOptions.class);
    public String keystore = "conf/.keystore";
    public String keystore_password = "cassandra";
    public String truststore = "conf/.truststore";
    public String truststore_password = "cassandra";
    public String[] cipher_suites = ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    public String protocol = "TLS";
    public String algorithm = "SunX509";
    public String store_type = "JKS";
    public boolean require_client_auth = false;
    public boolean require_endpoint_verification = false;

    public static class ServerEncryptionOptions
    extends EncryptionOptions {
        public InternodeEncryption internode_encryption = InternodeEncryption.none;

        public boolean shouldEncrypt(InetAddress endpoint) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            InetAddress local = FBUtilities.getBroadcastAddress();
            switch (this.internode_encryption) {
                case none: {
                    return false;
                }
                case all: {
                    break;
                }
                case dc: {
                    if (!snitch.getDatacenter(endpoint).equals(snitch.getDatacenter(local))) break;
                    return false;
                }
                case rack: {
                    if (!snitch.getRack(endpoint).equals(snitch.getRack(local)) || !snitch.getDatacenter(endpoint).equals(snitch.getDatacenter(local))) break;
                    return false;
                }
            }
            return true;
        }

        public void validate() {
            if (this.require_client_auth && (this.internode_encryption == InternodeEncryption.rack || this.internode_encryption == InternodeEncryption.dc)) {
                logger.warn("Setting require_client_auth is incompatible with 'rack' and 'dc' internode_encryption values. It is possible for an internode connection to pretend to be in the same rack/dc by spoofing its broadcast address in the handshake and bypass authentication. To ensure that mutual TLS authentication is not bypassed, please set internode_encryption to 'all'. Continuing with insecure configuration.");
            }
        }

        public static enum InternodeEncryption {
            all,
            none,
            dc,
            rack;

        }
    }

    public static class ClientEncryptionOptions
    extends EncryptionOptions {
        public boolean enabled = false;
        public boolean optional = false;
    }
}

