/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer;

import java.util.Locale;
import java.util.Map;

public class StandardTokenizerOptions {
    public static final String TOKENIZATION_ENABLE_STEMMING = "tokenization_enable_stemming";
    public static final String TOKENIZATION_SKIP_STOP_WORDS = "tokenization_skip_stop_words";
    public static final String TOKENIZATION_LOCALE = "tokenization_locale";
    public static final String TOKENIZATION_NORMALIZE_LOWERCASE = "tokenization_normalize_lowercase";
    public static final String TOKENIZATION_NORMALIZE_UPPERCASE = "tokenization_normalize_uppercase";
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    public static final int DEFAULT_MIN_TOKEN_LENGTH = 0;
    private boolean stemTerms;
    private boolean ignoreStopTerms;
    private Locale locale;
    private boolean caseSensitive;
    private boolean allTermsToUpperCase;
    private boolean allTermsToLowerCase;
    private int minTokenLength;
    private int maxTokenLength;

    public boolean shouldStemTerms() {
        return this.stemTerms;
    }

    public void setStemTerms(boolean stemTerms) {
        this.stemTerms = stemTerms;
    }

    public boolean shouldIgnoreStopTerms() {
        return this.ignoreStopTerms;
    }

    public void setIgnoreStopTerms(boolean ignoreStopTerms) {
        this.ignoreStopTerms = ignoreStopTerms;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean shouldUpperCaseTerms() {
        return this.allTermsToUpperCase;
    }

    public void setAllTermsToUpperCase(boolean allTermsToUpperCase) {
        this.allTermsToUpperCase = allTermsToUpperCase;
    }

    public boolean shouldLowerCaseTerms() {
        return this.allTermsToLowerCase;
    }

    public void setAllTermsToLowerCase(boolean allTermsToLowerCase) {
        this.allTermsToLowerCase = allTermsToLowerCase;
    }

    public int getMinTokenLength() {
        return this.minTokenLength;
    }

    public void setMinTokenLength(int minTokenLength) {
        this.minTokenLength = minTokenLength;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public void setMaxTokenLength(int maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
    }

    public static StandardTokenizerOptions buildFromMap(Map<String, String> optionsMap) {
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            switch (entry.getKey()) {
                case "tokenization_enable_stemming": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.stemTerms(bool);
                    break;
                }
                case "tokenization_skip_stop_words": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.ignoreStopTerms(bool);
                    break;
                }
                case "tokenization_locale": {
                    Locale locale = new Locale(entry.getValue());
                    optionsBuilder = optionsBuilder.useLocale(locale);
                    break;
                }
                case "tokenization_normalize_uppercase": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.alwaysUpperCaseTerms(bool);
                    break;
                }
                case "tokenization_normalize_lowercase": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.alwaysLowerCaseTerms(bool);
                    break;
                }
            }
        }
        return optionsBuilder.build();
    }

    public static StandardTokenizerOptions getDefaultOptions() {
        return new OptionsBuilder().ignoreStopTerms(true).alwaysLowerCaseTerms(true).stemTerms(false).useLocale(Locale.ENGLISH).build();
    }

    public static class OptionsBuilder {
        private boolean stemTerms;
        private boolean ignoreStopTerms;
        private Locale locale;
        private boolean caseSensitive;
        private boolean allTermsToUpperCase;
        private boolean allTermsToLowerCase;
        private int minTokenLength = 0;
        private int maxTokenLength = 255;

        public OptionsBuilder stemTerms(boolean stemTerms) {
            this.stemTerms = stemTerms;
            return this;
        }

        public OptionsBuilder ignoreStopTerms(boolean ignoreStopTerms) {
            this.ignoreStopTerms = ignoreStopTerms;
            return this;
        }

        public OptionsBuilder useLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public OptionsBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public OptionsBuilder alwaysUpperCaseTerms(boolean allTermsToUpperCase) {
            this.allTermsToUpperCase = allTermsToUpperCase;
            return this;
        }

        public OptionsBuilder alwaysLowerCaseTerms(boolean allTermsToLowerCase) {
            this.allTermsToLowerCase = allTermsToLowerCase;
            return this;
        }

        public OptionsBuilder minTokenLength(int minTokenLength) {
            if (minTokenLength < 1) {
                throw new IllegalArgumentException("minTokenLength must be greater than zero");
            }
            this.minTokenLength = minTokenLength;
            return this;
        }

        public OptionsBuilder maxTokenLength(int maxTokenLength) {
            if (maxTokenLength < 1) {
                throw new IllegalArgumentException("maxTokenLength must be greater than zero");
            }
            this.maxTokenLength = maxTokenLength;
            return this;
        }

        public StandardTokenizerOptions build() {
            if (this.allTermsToLowerCase && this.allTermsToUpperCase) {
                throw new IllegalArgumentException("Options to normalize terms cannot be both uppercase and lowercase at the same time");
            }
            StandardTokenizerOptions options = new StandardTokenizerOptions();
            options.setIgnoreStopTerms(this.ignoreStopTerms);
            options.setStemTerms(this.stemTerms);
            options.setLocale(this.locale);
            options.setCaseSensitive(this.caseSensitive);
            options.setAllTermsToLowerCase(this.allTermsToLowerCase);
            options.setAllTermsToUpperCase(this.allTermsToUpperCase);
            options.setMinTokenLength(this.minTokenLength);
            options.setMaxTokenLength(this.maxTokenLength);
            return options;
        }
    }
}

