/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetAddress;
import java.util.Map;

public class WriteFailureException
extends QueryConsistencyException {
    private final WriteType writeType;
    private final int numFailures;
    private final Map<InetAddress, Integer> reasonMap;

    public WriteFailureException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, @NonNull WriteType writeType, int numFailures, @NonNull Map<InetAddress, Integer> reasonMap) {
        this(coordinator, String.format("Cassandra failure during write query at consistency %s (%d responses were required but only %d replica responded, %d failed)", consistencyLevel, blockFor, received, numFailures), consistencyLevel, received, blockFor, writeType, numFailures, reasonMap, null, false);
    }

    private WriteFailureException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, @NonNull WriteType writeType, int numFailures, @NonNull Map<InetAddress, Integer> reasonMap, @Nullable ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, consistencyLevel, received, blockFor, executionInfo, writableStackTrace);
        this.writeType = writeType;
        this.numFailures = numFailures;
        this.reasonMap = reasonMap;
    }

    @NonNull
    public WriteType getWriteType() {
        return this.writeType;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    @NonNull
    public Map<InetAddress, Integer> getReasonMap() {
        return this.reasonMap;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new WriteFailureException(this.getCoordinator(), this.getMessage(), this.getConsistencyLevel(), this.getReceived(), this.getBlockFor(), this.writeType, this.numFailures, this.reasonMap, this.getExecutionInfo(), true);
    }
}

