/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.cassandra.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class CassandraSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name(connectorConfig.schemaNameAdjuster().adjust("source")).field("cluster", Schema.STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT32_SCHEMA).field("keyspace", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        return super.commonStruct((AbstractSourceInfo)sourceInfo).put("cluster", (Object)sourceInfo.cluster).put("file", (Object)sourceInfo.offsetPosition.fileName).put("pos", (Object)sourceInfo.offsetPosition.filePosition).put("keyspace", (Object)sourceInfo.keyspaceTable.keyspace).put("table", (Object)sourceInfo.keyspaceTable.table);
    }
}

