/*
 * Decompiled with CFR 0.152.
 */
package jflex.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import jflex.GeneratorException;
import jflex.Options;
import jflex.Skeleton;
import jflex.gui.GridPanel;

public class OptionsDialog
extends Dialog {
    private static final long serialVersionUID = 6807759416163314769L;
    private Frame owner;
    private Button skelBrowse;
    private TextField skelFile;
    private Button ok;
    private Button defaults;
    private Checkbox dump;
    private Checkbox verbose;
    private Checkbox time;
    private Checkbox no_minimize;
    private Checkbox no_backup;
    private Checkbox input_stream_ctor;
    private Checkbox jlex;
    private Checkbox dot;
    private Checkbox legacy_dot;

    public OptionsDialog(Frame owner) {
        super(owner, "Options");
        this.owner = owner;
        this.setup();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OptionsDialog.this.close();
            }
        });
    }

    public void setup() {
        this.ok = new Button("Ok");
        this.defaults = new Button("Defaults");
        this.skelBrowse = new Button(" Browse");
        this.skelFile = new TextField();
        this.skelFile.setEditable(false);
        this.legacy_dot = new Checkbox(" dot (.) matches [^\\n] instead of [^\\n\\r\\000B\\u000C\\u0085\\u2028\\u2029]");
        this.dump = new Checkbox(" dump");
        this.verbose = new Checkbox(" verbose");
        this.time = new Checkbox(" time statistics");
        this.no_minimize = new Checkbox(" skip minimization");
        this.no_backup = new Checkbox(" no backup file");
        this.input_stream_ctor = new Checkbox(" InputStream ctor");
        this.jlex = new Checkbox(" JLex compatibility");
        this.dot = new Checkbox(" dot graph files");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.close();
            }
        });
        this.defaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.setDefaults();
            }
        });
        this.skelBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.skelBrowse();
            }
        });
        this.verbose.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.verbose = OptionsDialog.this.verbose.getState();
            }
        });
        this.dump.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.dump = OptionsDialog.this.dump.getState();
            }
        });
        this.jlex.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.jlex = OptionsDialog.this.jlex.getState();
                OptionsDialog.this.legacy_dot.setState(false);
                OptionsDialog.this.legacy_dot.setEnabled(!OptionsDialog.this.jlex.getState());
            }
        });
        this.no_minimize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.no_minimize = OptionsDialog.this.no_minimize.getState();
            }
        });
        this.no_backup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.no_backup = OptionsDialog.this.no_backup.getState();
            }
        });
        this.dot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.dot = OptionsDialog.this.dot.getState();
            }
        });
        this.legacy_dot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.legacy_dot = OptionsDialog.this.legacy_dot.getState();
            }
        });
        this.time.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.time = OptionsDialog.this.time.getState();
            }
        });
        this.input_stream_ctor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.emitInputStreamCtor = OptionsDialog.this.input_stream_ctor.getState();
            }
        });
        GridPanel panel = new GridPanel(4, 5, 10, 10);
        panel.setInsets(new Insets(10, 5, 5, 10));
        panel.add(3, 0, this.ok);
        panel.add(3, 1, this.defaults);
        panel.add(0, 0, 2, 1, 7, new Label("skeleton file:"));
        panel.add(0, 1, 2, 1, this.skelFile);
        panel.add(2, 1, 1, 1, 1, this.skelBrowse);
        panel.add(0, 4, 4, 1, this.legacy_dot);
        panel.add(0, 2, 1, 1, this.dump);
        panel.add(0, 3, 1, 1, this.verbose);
        panel.add(1, 2, 1, 1, this.time);
        panel.add(1, 3, 1, 1, this.no_minimize);
        panel.add(2, 2, 1, 1, this.no_backup);
        panel.add(2, 3, 1, 1, this.input_stream_ctor);
        panel.add(3, 2, 1, 1, this.jlex);
        panel.add(3, 3, 1, 1, this.dot);
        this.add("Center", panel);
        this.updateState();
    }

    private void skelBrowse() {
        FileDialog d = new FileDialog(this.owner, "Choose file", 0);
        d.setVisible(true);
        if (d.getFile() != null) {
            File skel = new File(d.getDirectory() + d.getFile());
            try {
                Skeleton.readSkelFile(skel);
                this.skelFile.setText(skel.toString());
            }
            catch (GeneratorException generatorException) {
                // empty catch block
            }
        }
    }

    private void updateState() {
        this.legacy_dot.setState(Options.legacy_dot);
        this.dump.setState(Options.dump);
        this.verbose.setState(Options.verbose);
        this.time.setState(Options.time);
        this.no_minimize.setState(Options.no_minimize);
        this.no_backup.setState(Options.no_backup);
        this.input_stream_ctor.setState(Options.emitInputStreamCtor);
        this.jlex.setState(Options.jlex);
        this.dot.setState(Options.dot);
    }

    private void setDefaults() {
        Options.setDefaults();
        Skeleton.readDefault();
        this.skelFile.setText("");
        this.updateState();
        this.legacy_dot.setEnabled(!this.jlex.getState());
    }

    public void close() {
        this.setVisible(false);
    }
}

