/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics.reporter.config.AbstractCsvReporterConfig;
import com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReporterConfig
extends AbstractCsvReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(CsvReporterConfig.class);
    private CsvReporter reporter;

    @Override
    public boolean enable(MetricRegistry registry) {
        log.info("Enabling CsvReporter to {}", (Object)this.outdir);
        try {
            File foutDir = this.createFile();
            if (foutDir == null) {
                log.error("Failed to create directory {} for CsvReporter", (Object)this.outdir);
                return false;
            }
            this.reporter = CsvReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRealRateunit()).convertDurationsTo(this.getRealDurationunit()).filter(MetricFilterTransformer.generateFilter(this.getPredicate())).build(foutDir);
            this.reporter.start(this.getPeriod(), this.getRealTimeunit());
        }
        catch (Exception e) {
            log.error("Failure while Enabling CsvReporter", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void report() {
        if (this.reporter != null) {
            this.reporter.report();
        }
    }
}

