/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CassandraOffsetContext;
import io.debezium.connector.cassandra.CassandraPartition;
import io.debezium.connector.cassandra.ComponentFactory;
import io.debezium.connector.cassandra.Emitter;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.SourceRecordEmitter;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.spi.topic.TopicNamingStrategy;

public class ComponentFactoryDebezium
implements ComponentFactory {
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final CassandraPartition partition;
    private final CassandraOffsetContext offset;

    public ComponentFactoryDebezium(ChangeEventQueue<DataChangeEvent> queue, CassandraPartition partition, CassandraOffsetContext offset) {
        this.queue = queue;
        this.partition = partition;
        this.offset = offset;
    }

    @Override
    public Emitter recordEmitter(CassandraConnectorContext context) {
        return new SourceRecordEmitter(this.queue, (TopicNamingStrategy<KeyspaceTable>)context.getCassandraConnectorConfig().getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY), this.partition, this.offset);
    }

    @Override
    public OffsetWriter offsetWriter(CassandraConnectorConfig config) {
        return new OffsetWriter(){

            @Override
            public void markOffset(String sourceTable, String sourceOffset, boolean isSnapshot) {
                ComponentFactoryDebezium.this.offset.putOffset(sourceTable, isSnapshot, sourceOffset);
            }

            @Override
            public boolean isOffsetProcessed(String sourceTable, String sourceOffset, boolean isSnapshot) {
                String previousOffset = ComponentFactoryDebezium.this.offset.getOffset(sourceTable, isSnapshot);
                OffsetPosition previousOffsetPosition = previousOffset == null ? null : OffsetPosition.parse(previousOffset);
                OffsetPosition currentOffsetPosition = OffsetPosition.parse(sourceOffset);
                return previousOffsetPosition != null && currentOffsetPosition.compareTo(previousOffsetPosition) <= 0;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }
}

