/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.AbstractSchemaChangeListener;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.SchemaChangeListenerProvider;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SchemaLoader;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.connector.common.CdcSourceTaskContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CassandraConnectorContext
extends CdcSourceTaskContext {
    private final CassandraConnectorConfig config;
    private CassandraClient cassandraClient;
    private final List<ChangeEventQueue<Event>> queues = new ArrayList<ChangeEventQueue<Event>>();
    private SchemaHolder schemaHolder;
    private OffsetWriter offsetWriter;
    private final Set<String> erroneousCommitLogs = ConcurrentHashMap.newKeySet();

    public CassandraConnectorContext(CassandraConnectorConfig config) {
        super(config.getContextName(), config.getLogicalName(), config.getCustomMetricTags(), Collections::emptySet);
        this.config = config;
        this.prepareQueues();
    }

    public CassandraConnectorContext(CassandraConnectorConfig config, SchemaLoader schemaLoader, SchemaChangeListenerProvider schemaChangeListenerProvider, OffsetWriter offsetWriter) {
        super(config.getContextName(), config.getLogicalName(), config.getCustomMetricTags(), Collections::emptySet);
        this.config = config;
        this.offsetWriter = offsetWriter;
        try {
            this.prepareQueues();
            schemaLoader.load(this.config.cassandraConfig());
            AbstractSchemaChangeListener schemaChangeListener = schemaChangeListenerProvider.provide(this.config);
            this.cassandraClient = new CassandraClient(config.cassandraDriverConfig(), (SchemaChangeListener)schemaChangeListener);
            this.schemaHolder = schemaChangeListener.getSchemaHolder();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new CassandraConnectorTaskException("Failed to initialize Cassandra Connector Context.", e);
        }
    }

    private void prepareQueues() {
        int numOfChangeEventQueues = this.config.numOfChangeEventQueues();
        for (int i = 0; i < numOfChangeEventQueues; ++i) {
            ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(this.config.pollInterval()).maxBatchSize(this.config.maxBatchSize()).maxQueueSize(this.config.maxQueueSize()).loggingContextSupplier(() -> this.configureLoggingContext(this.config.getContextName())).build();
            this.queues.add((ChangeEventQueue<Event>)queue);
        }
    }

    public void cleanUp() {
        if (this.cassandraClient != null) {
            this.cassandraClient.close();
        }
        if (this.offsetWriter != null) {
            this.offsetWriter.close();
        }
    }

    public CassandraConnectorConfig getCassandraConnectorConfig() {
        return this.config;
    }

    public CassandraClient getCassandraClient() {
        return this.cassandraClient;
    }

    public List<ChangeEventQueue<Event>> getQueues() {
        return this.queues;
    }

    public OffsetWriter getOffsetWriter() {
        return this.offsetWriter;
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public Set<String> getErroneousCommitLogs() {
        return this.erroneousCommitLogs;
    }
}

