/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.DataException;

public class Decimal {
    public static final String LOGICAL_NAME = "org.apache.kafka.connect.data.Decimal";
    public static final String SCALE_FIELD = "scale";

    public static SchemaBuilder builder(int scale) {
        return SchemaBuilder.bytes().name(LOGICAL_NAME).parameter(SCALE_FIELD, Integer.toString(scale)).version(1);
    }

    public static Schema schema(int scale) {
        return Decimal.builder(scale).build();
    }

    public static byte[] fromLogical(Schema schema, BigDecimal value) {
        int schemaScale = Decimal.scale(schema);
        if (value.scale() != schemaScale) {
            throw new DataException(String.format("Decimal value has mismatching scale for given Decimal schema. Schema has scale %d, value has scale %d.", schemaScale, value.scale()));
        }
        return value.unscaledValue().toByteArray();
    }

    public static BigDecimal toLogical(Schema schema, byte[] value) {
        return new BigDecimal(new BigInteger(value), Decimal.scale(schema));
    }

    private static int scale(Schema schema) {
        String scaleString = schema.parameters().get(SCALE_FIELD);
        if (scaleString == null) {
            throw new DataException("Invalid Decimal schema: scale parameter not found.");
        }
        try {
            return Integer.parseInt(scaleString);
        }
        catch (NumberFormatException e) {
            throw new DataException("Invalid scale parameter found in Decimal schema: ", e);
        }
    }
}

