/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.driver.shaded.netty.util.concurrent.EventExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class RunOrSchedule {
    public static void on(EventExecutor executor, Runnable task) {
        if (executor.inEventLoop()) {
            task.run();
        } else {
            executor.submit(task).addListener(UncaughtExceptions::log);
        }
    }

    public static <T> Consumer<T> on(EventExecutor executor, Consumer<T> task) {
        return t -> {
            if (executor.inEventLoop()) {
                task.accept(t);
            } else {
                executor.submit(() -> task.accept(t)).addListener(UncaughtExceptions::log);
            }
        };
    }

    public static <T> CompletionStage<T> on(EventExecutor executor, Callable<CompletionStage<T>> task) {
        if (executor.inEventLoop()) {
            try {
                return task.call();
            }
            catch (Exception e) {
                return CompletableFutures.failedFuture(e);
            }
        }
        CompletableFuture result = new CompletableFuture();
        executor.submit(task).addListener(f -> {
            if (f.isSuccess()) {
                CompletableFutures.completeFrom((CompletionStage)f.getNow(), result);
            } else {
                result.completeExceptionally(f.cause());
            }
        });
        return result;
    }
}

