/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.CassandraSchemaFactory;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class KeyValueSchema {
    private final TableMetadata tableMetadata;
    private final Schema keySchema;
    private final Schema valueSchema;

    KeyValueSchema(TableMetadata tableMetadata, Schema keySchema, Schema valueSchema) {
        this.tableMetadata = tableMetadata;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
    }

    public static List<String> getPrimaryKeyNames(TableMetadata tm) {
        return tm.getPrimaryKey().stream().map(md -> md.getName().toString()).collect(Collectors.toList());
    }

    public static List<Schema> getPrimaryKeySchemas(TableMetadata tm) {
        return tm.getPrimaryKey().stream().map(ColumnMetadata::getType).map(type -> CassandraTypeDeserializer.getSchemaBuilder(type).build()).collect(Collectors.toList());
    }

    public static List<Schema> getPrimaryKeySchemas(List<DataType> dataTypes) {
        return dataTypes.stream().map(type -> CassandraTypeDeserializer.getSchemaBuilder(type).build()).collect(Collectors.toList());
    }

    public TableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public static Schema getFieldSchema(String fieldName, Schema schema) {
        if (schema.type().equals((Object)Schema.Type.STRUCT)) {
            return schema.field(fieldName).schema();
        }
        throw new CassandraConnectorSchemaException("Only STRUCT type is supported for this method, but encountered " + schema.type());
    }

    public static class KeyValueSchemaBuilder {
        private static final String NAMESPACE = "io.debezium.connector.cassandra";
        private String keyspace;
        private String table;
        private TableMetadata tableMetadata;
        private String kafkaTopicPrefix;
        private SourceInfoStructMaker<?> sourceInfoStructMaker;
        private List<String> primaryKeyNames;
        private List<Schema> primaryKeySchemas;
        private Schema rowSchema;

        public KeyValueSchemaBuilder withKeyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public KeyValueSchemaBuilder withTable(String table) {
            this.table = table;
            return this;
        }

        public KeyValueSchemaBuilder withKafkaTopicPrefix(String kafkaTopicPrefix) {
            this.kafkaTopicPrefix = kafkaTopicPrefix;
            return this;
        }

        public KeyValueSchemaBuilder withSourceInfoStructMarker(SourceInfoStructMaker<?> sourceInfoStructMarker) {
            this.sourceInfoStructMaker = sourceInfoStructMarker;
            return this;
        }

        public KeyValueSchemaBuilder withPrimaryKeyNames(List<String> primaryKeyNames) {
            this.primaryKeyNames = primaryKeyNames;
            return this;
        }

        public KeyValueSchemaBuilder withPrimaryKeySchemas(List<Schema> primaryKeySchemas) {
            this.primaryKeySchemas = primaryKeySchemas;
            return this;
        }

        public KeyValueSchemaBuilder withRowSchema(Schema rowSchema) {
            this.rowSchema = rowSchema;
            return this;
        }

        public KeyValueSchemaBuilder withTableMetadata(TableMetadata tableMetadata) {
            if (tableMetadata != null) {
                this.tableMetadata = tableMetadata;
                this.keyspace = this.tableMetadata.getKeyspace().toString();
                this.table = this.tableMetadata.getName().toString();
            }
            return this;
        }

        private String getKeyName() {
            return this.kafkaTopicPrefix + "." + this.keyspace + "." + this.table + ".Key";
        }

        private String getValueName() {
            return this.kafkaTopicPrefix + "." + this.keyspace + "." + this.table + ".Envelope";
        }

        private Schema getKeySchema() {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("io.debezium.connector.cassandra." + this.getKeyName());
            for (int i = 0; i < this.primaryKeyNames.size(); ++i) {
                schemaBuilder.field(this.primaryKeyNames.get(i), this.primaryKeySchemas.get(i));
            }
            return schemaBuilder.build();
        }

        private Schema getValueSchema() {
            return SchemaBuilder.struct().name("io.debezium.connector.cassandra." + this.getValueName()).field("ts_ms", Schema.INT64_SCHEMA).field("op", Schema.STRING_SCHEMA).field("source", this.sourceInfoStructMaker.schema()).field("after", this.rowSchema).build();
        }

        public KeyValueSchema build() {
            if ((this.primaryKeyNames == null || this.primaryKeySchemas == null) && this.tableMetadata == null) {
                throw new IllegalStateException("Unable to build, tableMetadata are null and either primaryKeyNames and/or primaryKeyValues are not set.");
            }
            if (this.primaryKeyNames == null) {
                this.primaryKeyNames = KeyValueSchema.getPrimaryKeyNames(this.tableMetadata);
            }
            if (this.primaryKeySchemas == null) {
                this.primaryKeySchemas = KeyValueSchema.getPrimaryKeySchemas(this.tableMetadata);
            }
            if (this.rowSchema == null) {
                if (this.tableMetadata != null) {
                    this.rowSchema = CassandraSchemaFactory.RowData.rowSchema(this.tableMetadata);
                } else {
                    throw new IllegalStateException("Unable to build, rowSchema is not set and table metadata are null");
                }
            }
            if (this.keyspace == null) {
                if (this.tableMetadata == null) {
                    throw new IllegalStateException("Keyspace is not set and TableMetadata is not set either");
                }
                this.keyspace = this.tableMetadata.getKeyspace().toString();
            }
            if (this.table == null) {
                if (this.tableMetadata == null) {
                    throw new IllegalStateException("Table is not set and TableMetadata is not either");
                }
                this.table = this.tableMetadata.getName().toString();
            }
            return new KeyValueSchema(this.tableMetadata, this.getKeySchema(), this.getValueSchema());
        }
    }
}

