/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.scheduler;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.metrics.LatencyMetrics;

class WeightedQueue {
    private final LatencyMetrics metric;
    public final String key;
    public final int weight;
    private final SynchronousQueue<Entry> queue;

    public WeightedQueue(String key, int weight) {
        this.key = key;
        this.weight = weight;
        this.queue = new SynchronousQueue(true);
        this.metric = new LatencyMetrics("scheduler", "WeightedQueue", key);
    }

    public void put(Thread t, long timeoutMS) throws InterruptedException, TimeoutException {
        if (!this.queue.offer(new Entry(t), timeoutMS, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Failed to acquire request scheduler slot for '" + this.key + "'");
        }
    }

    public Thread poll() {
        Entry e = this.queue.poll();
        if (e == null) {
            return null;
        }
        this.metric.addNano(System.nanoTime() - e.creationTime);
        return e.thread;
    }

    public String toString() {
        return "RoundRobinScheduler.WeightedQueue(key=" + this.key + " weight=" + this.weight + ")";
    }

    private static final class Entry {
        public final long creationTime = System.nanoTime();
        public final Thread thread;

        public Entry(Thread thread) {
            this.thread = thread;
        }
    }
}

