/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import io.debezium.DebeziumException;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CassandraSchemaFactory;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.RangeTombstoneContext;
import io.debezium.connector.cassandra.RecordMaker;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.time.Conversions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.commitlog.CommitLogDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogReadHandler;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra3CommitLogReadHandlerImpl
implements CommitLogReadHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cassandra3CommitLogReadHandlerImpl.class);
    private static final boolean MARK_OFFSET = true;
    private final List<ChangeEventQueue<Event>> queues;
    private final RecordMaker recordMaker;
    private final OffsetWriter offsetWriter;
    private final SchemaHolder schemaHolder;
    private final CommitLogProcessorMetrics metrics;
    private final RangeTombstoneContext<CFMetaData> rangeTombstoneContext = new RangeTombstoneContext();
    private final CassandraSchemaFactory schemaFactory;

    Cassandra3CommitLogReadHandlerImpl(CassandraConnectorContext context, CommitLogProcessorMetrics metrics) {
        this.queues = context.getQueues();
        this.recordMaker = new RecordMaker(context.getCassandraConnectorConfig().tombstonesOnDelete(), new Filters(context.getCassandraConnectorConfig().fieldExcludeList()), context.getCassandraConnectorConfig());
        this.offsetWriter = context.getOffsetWriter();
        this.schemaHolder = context.getSchemaHolder();
        this.metrics = metrics;
        this.schemaFactory = CassandraSchemaFactory.get();
    }

    public void handleMutation(Mutation mutation, int size, int entryLocation, CommitLogDescriptor descriptor) {
        if (!mutation.trackedByCDC()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("not tracked by cdc {}.{{}}", (Object)mutation.getKeyspaceName(), mutation.getPartitionUpdates().stream().map(pa -> pa.metadata().cfName).collect(Collectors.toSet()));
            }
            return;
        }
        this.metrics.setCommitLogPosition((long)entryLocation);
        for (PartitionUpdate pu : mutation.getPartitionUpdates()) {
            OffsetPosition offsetPosition = new OffsetPosition(descriptor.fileName(), entryLocation);
            KeyspaceTable keyspaceTable = new KeyspaceTable(mutation.getKeyspaceName(), pu.metadata().cfName);
            if (this.offsetWriter.isOffsetProcessed(keyspaceTable.name(), offsetPosition.serialize(), false)) {
                LOGGER.info("Mutation at {} for table {} already processed, skipping...", (Object)offsetPosition, (Object)keyspaceTable);
                return;
            }
            try {
                this.process(pu, offsetPosition, keyspaceTable);
            }
            catch (Exception e) {
                throw new DebeziumException(String.format("Failed to process PartitionUpdate %s at %s for table %s.", pu, offsetPosition, keyspaceTable.name()), (Throwable)e);
            }
        }
        this.metrics.onSuccess();
    }

    public void handleUnrecoverableError(CommitLogReadHandler.CommitLogReadException exception) {
        LOGGER.error("Unrecoverable error when reading commit log", (Throwable)exception);
        this.metrics.onUnrecoverableError();
    }

    public boolean shouldSkipSegmentOnError(CommitLogReadHandler.CommitLogReadException exception) {
        if (exception.permissible) {
            LOGGER.error("Encountered a permissible exception during log replay", (Throwable)exception);
        } else {
            LOGGER.error("Encountered a non-permissible exception during log replay", (Throwable)exception);
        }
        return false;
    }

    private void process(PartitionUpdate pu, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable) {
        PartitionType partitionType = PartitionType.getPartitionType(pu);
        if (!PartitionType.isValid(partitionType)) {
            LOGGER.warn("Encountered an unsupported partition type {}, skipping...", (Object)partitionType);
            return;
        }
        switch (partitionType) {
            case PARTITION_KEY_ROW_DELETION: 
            case PARTITION_AND_CLUSTERING_KEY_ROW_DELETION: {
                this.handlePartitionDeletion(pu, offsetPosition, keyspaceTable);
                break;
            }
            case ROW_LEVEL_MODIFICATION: {
                UnfilteredRowIterator it = pu.unfilteredIterator();
                while (it.hasNext()) {
                    Unfiltered rowOrRangeTombstone = (Unfiltered)it.next();
                    RowType rowType = RowType.getRowType(rowOrRangeTombstone);
                    if (!RowType.isValid(rowType)) {
                        LOGGER.warn("Encountered an unsupported row type {}, skipping...", (Object)rowType);
                        continue;
                    }
                    if (rowOrRangeTombstone instanceof Row) {
                        Row row = (Row)rowOrRangeTombstone;
                        this.handleRowModifications(row, rowType, pu, offsetPosition, keyspaceTable);
                        continue;
                    }
                    if (rowOrRangeTombstone instanceof RangeTombstoneBoundMarker) {
                        this.handleRangeTombstoneBoundMarker((RangeTombstoneBoundMarker)rowOrRangeTombstone, rowType, pu, offsetPosition, keyspaceTable);
                        continue;
                    }
                    throw new CassandraConnectorSchemaException("Encountered unsupported Unfiltered type " + rowOrRangeTombstone.getClass());
                }
                break;
            }
            default: {
                throw new CassandraConnectorSchemaException("Unsupported partition type " + partitionType + " should have been skipped");
            }
        }
    }

    private void handlePartitionDeletion(PartitionUpdate pu, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable) {
        long deletionTs;
        KeyValueSchema keyValueSchema = this.schemaHolder.getKeyValueSchema(keyspaceTable);
        if (keyValueSchema == null) {
            LOGGER.warn("Unable to get KeyValueSchema for table {}. It might have been deleted or CDC disabled.", (Object)keyspaceTable.toString());
            return;
        }
        Schema keySchema = keyValueSchema.keySchema();
        Schema valueSchema = keyValueSchema.valueSchema();
        TableMetadata tableMetadata = keyValueSchema.tableMetadata();
        CassandraSchemaFactory.RowData after = this.schemaFactory.rowData();
        this.populatePartitionColumns(after, pu);
        ArrayList columns = new ArrayList(tableMetadata.getColumns().values());
        Map clusteringColumns = tableMetadata.getClusteringColumns();
        for (Map.Entry clustering : clusteringColumns.entrySet()) {
            ColumnMetadata clusteringKey = (ColumnMetadata)clustering.getKey();
            deletionTs = pu.deletionInfo().getPartitionDeletion().markedForDeleteAt();
            after.addCell(this.schemaFactory.cellData(clusteringKey.getName().toString(), null, (Object)deletionTs, CassandraSchemaFactory.CellData.ColumnType.CLUSTERING));
        }
        columns.removeAll(tableMetadata.getPartitionKey());
        columns.removeAll(tableMetadata.getClusteringColumns().keySet());
        for (ColumnMetadata cm : columns) {
            String name = cm.getName().toString();
            deletionTs = pu.deletionInfo().getPartitionDeletion().markedForDeleteAt();
            CassandraSchemaFactory.CellData cellData = this.schemaFactory.cellData(name, null, (Object)deletionTs, CassandraSchemaFactory.CellData.ColumnType.REGULAR);
            after.addCell(cellData);
        }
        this.recordMaker.delete(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)pu.maxTimestamp()), after, keySchema, valueSchema, true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
    }

    private void handleRowModifications(Row row, RowType rowType, PartitionUpdate pu, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable) {
        KeyValueSchema keyValueSchema = this.schemaHolder.getKeyValueSchema(keyspaceTable);
        if (keyValueSchema == null) {
            LOGGER.trace("Unable to get KeyValueSchema for table {}. It might have been deleted or CDC disabled.", (Object)keyspaceTable.toString());
            return;
        }
        Schema keySchema = keyValueSchema.keySchema();
        Schema valueSchema = keyValueSchema.valueSchema();
        CassandraSchemaFactory.RowData after = this.schemaFactory.rowData();
        this.populatePartitionColumns(after, pu);
        this.populateClusteringColumns(after, row, pu);
        this.populateRegularColumns(after, row, rowType, keyValueSchema);
        long ts = rowType == RowType.DELETE ? row.deletion().time().markedForDeleteAt() : pu.maxTimestamp();
        switch (rowType) {
            case INSERT: {
                this.recordMaker.insert(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)ts), after, keySchema, valueSchema, true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
                break;
            }
            case UPDATE: {
                this.recordMaker.update(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)ts), after, keySchema, valueSchema, true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
                break;
            }
            case DELETE: {
                this.recordMaker.delete(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)ts), after, keySchema, valueSchema, true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
                break;
            }
            case RANGE_TOMBSTONE: {
                this.recordMaker.rangeTombstone(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)ts), after, keySchema, valueSchema, true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
                break;
            }
            default: {
                throw new CassandraConnectorSchemaException("Unsupported row type " + rowType + " should have been skipped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRangeTombstoneBoundMarker(RangeTombstoneBoundMarker rangeTombstoneMarker, RowType rowType, PartitionUpdate pu, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable) {
        if (rowType != RowType.RANGE_TOMBSTONE) {
            throw new IllegalStateException("Row type has to be " + RowType.RANGE_TOMBSTONE.name());
        }
        KeyValueSchema keyValueSchema = this.schemaHolder.getKeyValueSchema(keyspaceTable);
        if (keyValueSchema == null) {
            LOGGER.warn("Unable to get KeyValueSchema for table {}. It might have been deleted or CDC disabled.", (Object)keyspaceTable.toString());
            return;
        }
        CassandraSchemaFactory.RowData after = this.rangeTombstoneContext.getOrCreate((Object)pu.metadata());
        Optional.ofNullable(rangeTombstoneMarker.openBound(false)).ifPresent(cb -> after.addStartRange(this.populateRangeData((ClusteringBound)cb, "_range_start", pu.metadata())));
        Optional.ofNullable(rangeTombstoneMarker.closeBound(false)).ifPresent(cb -> after.addEndRange(this.populateRangeData((ClusteringBound)cb, "_range_end", pu.metadata())));
        if (RangeTombstoneContext.isComplete((CassandraSchemaFactory.RowData)after)) {
            try {
                this.populatePartitionColumns(after, pu);
                long ts = rangeTombstoneMarker.deletionTime().markedForDeleteAt();
                this.recordMaker.rangeTombstone(DatabaseDescriptor.getClusterName(), offsetPosition, keyspaceTable, false, Conversions.toInstantFromMicros((long)ts), after, keyValueSchema.keySchema(), keyValueSchema.valueSchema(), true, arg_0 -> this.queues.get(Math.abs(offsetPosition.fileName.hashCode() % this.queues.size())).enqueue(arg_0));
            }
            finally {
                this.rangeTombstoneContext.remove((Object)pu.metadata());
            }
        }
    }

    private CassandraSchemaFactory.RangeData populateRangeData(ClusteringBound cb, String name, CFMetaData metaData) {
        HashMap<String, Pair> values = new HashMap<String, Pair>();
        for (int i = 0; i < cb.size(); ++i) {
            String clusteringColumnName = ((ColumnDefinition)metaData.clusteringColumns().get((int)i)).name.toCQLString();
            String clusteringColumnValue = metaData.comparator.subtype(i).getString(cb.get(i));
            String clusteringColumnType = ((ColumnDefinition)metaData.clusteringColumns().get((int)i)).type.toString();
            values.put(clusteringColumnName, Pair.of((Object)clusteringColumnValue, (Object)clusteringColumnType));
        }
        return this.schemaFactory.rangeData(name, cb.kind().toString(), values);
    }

    private void populatePartitionColumns(CassandraSchemaFactory.RowData after, PartitionUpdate pu) {
        if (after.hasAnyCell()) {
            return;
        }
        List<Object> partitionKeys = this.getPartitionKeys(pu);
        for (ColumnDefinition cd : pu.metadata().partitionKeyColumns()) {
            try {
                String name = cd.name.toString();
                Object value = partitionKeys.get(cd.position());
                CassandraSchemaFactory.CellData cellData = this.schemaFactory.cellData(name, value, null, CassandraSchemaFactory.CellData.ColumnType.PARTITION);
                after.addCell(cellData);
            }
            catch (Exception e) {
                throw new DebeziumException(String.format("Failed to populate Column %s with Type %s of Table %s in KeySpace %s.", cd.name.toString(), cd.type.toString(), cd.cfName, cd.ksName), (Throwable)e);
            }
        }
    }

    private void populateClusteringColumns(CassandraSchemaFactory.RowData after, Row row, PartitionUpdate pu) {
        for (ColumnDefinition cd : pu.metadata().clusteringColumns()) {
            try {
                ByteBuffer bufferAtClustering = row.clustering().get(cd.position());
                Object value = CassandraTypeDeserializer.deserialize((Object)cd.type, (ByteBuffer)bufferAtClustering);
                CassandraSchemaFactory.CellData cellData = this.schemaFactory.cellData(cd.name.toString(), value, null, CassandraSchemaFactory.CellData.ColumnType.CLUSTERING);
                after.addCell(cellData);
            }
            catch (Exception e) {
                throw new DebeziumException(String.format("Failed to populate Column %s with Type %s of Table %s in KeySpace %s.", cd.name.toString(), cd.type.toString(), cd.cfName, cd.ksName), (Throwable)e);
            }
        }
    }

    private void populateRegularColumns(CassandraSchemaFactory.RowData after, Row row, RowType rowType, KeyValueSchema schema) {
        block7: {
            block6: {
                if (rowType != RowType.INSERT && rowType != RowType.UPDATE) break block6;
                for (ColumnDefinition cd : row.columns()) {
                    try {
                        Object value;
                        Long deletionTs = null;
                        AbstractType abstractType = cd.type;
                        if (abstractType.isCollection() && abstractType.isMultiCell()) {
                            ComplexColumnData ccd = row.getComplexColumnData(cd);
                            value = CassandraTypeDeserializer.deserialize((Object)((CollectionType)abstractType), this.getComplexColumnDataByteBufferList(abstractType, ccd));
                        } else {
                            Cell cell = row.getCell(cd);
                            value = cell.isTombstone() ? null : CassandraTypeDeserializer.deserialize((Object)abstractType, (ByteBuffer)cell.value());
                            deletionTs = cell.isExpiring() ? Long.valueOf(TimeUnit.MICROSECONDS.convert(cell.localDeletionTime(), TimeUnit.SECONDS)) : null;
                        }
                        String name = cd.name.toString();
                        CassandraSchemaFactory.CellData cellData = this.schemaFactory.cellData(name, value, (Object)deletionTs, CassandraSchemaFactory.CellData.ColumnType.REGULAR);
                        after.addCell(cellData);
                    }
                    catch (Exception e) {
                        throw new DebeziumException(String.format("Failed to populate Column %s with Type %s of Table %s in KeySpace %s.", cd.name.toString(), cd.type.toString(), cd.cfName, cd.ksName), (Throwable)e);
                    }
                }
                break block7;
            }
            if (rowType != RowType.DELETE) break block7;
            TableMetadata tableMetadata = schema.tableMetadata();
            ArrayList columns = new ArrayList(tableMetadata.getColumns().values());
            columns.removeAll(tableMetadata.getPrimaryKey());
            for (ColumnMetadata cm : columns) {
                String name = cm.getName().toString();
                long deletionTs = row.deletion().time().markedForDeleteAt();
                CassandraSchemaFactory.CellData cellData = this.schemaFactory.cellData(name, null, (Object)deletionTs, CassandraSchemaFactory.CellData.ColumnType.REGULAR);
                after.addCell(cellData);
            }
        }
    }

    private List<ByteBuffer> getComplexColumnDataByteBufferList(AbstractType<?> abstractType, ComplexColumnData ccd) {
        if (abstractType instanceof ListType) {
            return ((ListType)abstractType).serializedValues(ccd.iterator());
        }
        if (abstractType instanceof SetType) {
            return ((SetType)abstractType).serializedValues(ccd.iterator());
        }
        if (abstractType instanceof MapType) {
            return ((MapType)abstractType).serializedValues(ccd.iterator());
        }
        throw new DebeziumException(String.format("Unknow collection type %s", abstractType));
    }

    private List<Object> getPartitionKeys(PartitionUpdate pu) {
        int header;
        ArrayList<Object> values = new ArrayList<Object>();
        List columnDefinitions = pu.metadata().partitionKeyColumns();
        if (columnDefinitions.size() == 1) {
            ByteBuffer bb = pu.partitionKey().getKey();
            ColumnSpecification cs = (ColumnSpecification)columnDefinitions.get(0);
            AbstractType type = cs.type;
            try {
                Object value = CassandraTypeDeserializer.deserialize((Object)type, (ByteBuffer)bb);
                values.add(value);
            }
            catch (Exception e) {
                throw new DebeziumException(String.format("Failed to deserialize Column %s with Type %s in Table %s and KeySpace %s.", cs.name.toString(), cs.type.toString(), cs.cfName, cs.ksName), (Throwable)e);
            }
        }
        ByteBuffer keyBytes = pu.partitionKey().getKey().duplicate();
        if (keyBytes.remaining() >= 2 && ((header = ByteBufferUtil.getShortLength((ByteBuffer)keyBytes, (int)keyBytes.position())) & 0xFFFF) == 65535) {
            ByteBufferUtil.readShortLength((ByteBuffer)keyBytes);
        }
        for (int i = 0; keyBytes.remaining() > 0 && i < columnDefinitions.size(); ++i) {
            ColumnSpecification cs = (ColumnSpecification)columnDefinitions.get(i);
            AbstractType type = cs.type;
            ByteBuffer bb = ByteBufferUtil.readBytesWithShortLength((ByteBuffer)keyBytes);
            try {
                Object value = CassandraTypeDeserializer.deserialize((Object)type, (ByteBuffer)bb);
                values.add(value);
            }
            catch (Exception e) {
                throw new DebeziumException(String.format("Failed to deserialize Column %s with Type %s in Table %s and KeySpace %s", cs.name.toString(), cs.type.toString(), cs.cfName, cs.ksName), (Throwable)e);
            }
            byte b = keyBytes.get();
            if (b != 0) break;
        }
        return values;
    }

    static enum PartitionType {
        PARTITION_KEY_ROW_DELETION,
        PARTITION_AND_CLUSTERING_KEY_ROW_DELETION,
        ROW_LEVEL_MODIFICATION,
        MATERIALIZED_VIEW,
        SECONDARY_INDEX,
        COUNTER;

        static final Set<PartitionType> supportedPartitionTypes;

        public static PartitionType getPartitionType(PartitionUpdate pu) {
            if (pu.metadata().isCounter()) {
                return COUNTER;
            }
            if (pu.metadata().isView()) {
                return MATERIALIZED_VIEW;
            }
            if (pu.metadata().isIndex()) {
                return SECONDARY_INDEX;
            }
            if (PartitionType.isPartitionDeletion(pu) && PartitionType.hasClusteringKeys(pu)) {
                return PARTITION_AND_CLUSTERING_KEY_ROW_DELETION;
            }
            if (PartitionType.isPartitionDeletion(pu) && !PartitionType.hasClusteringKeys(pu)) {
                return PARTITION_KEY_ROW_DELETION;
            }
            return ROW_LEVEL_MODIFICATION;
        }

        public static boolean isValid(PartitionType type) {
            return supportedPartitionTypes.contains((Object)type);
        }

        public static boolean hasClusteringKeys(PartitionUpdate pu) {
            return !pu.metadata().clusteringColumns().isEmpty();
        }

        public static boolean isPartitionDeletion(PartitionUpdate pu) {
            return pu.partitionLevelDeletion().markedForDeleteAt() > Long.MIN_VALUE;
        }

        static {
            supportedPartitionTypes = new HashSet<PartitionType>(Arrays.asList(PARTITION_KEY_ROW_DELETION, PARTITION_AND_CLUSTERING_KEY_ROW_DELETION, ROW_LEVEL_MODIFICATION));
        }
    }

    static enum RowType {
        INSERT,
        UPDATE,
        DELETE,
        RANGE_TOMBSTONE,
        UNKNOWN;

        static final Set<RowType> supportedRowTypes;

        public static RowType getRowType(Unfiltered unfiltered) {
            if (unfiltered.isRangeTombstoneMarker()) {
                return RANGE_TOMBSTONE;
            }
            if (unfiltered.isRow()) {
                Row row = (Row)unfiltered;
                if (RowType.isDelete(row)) {
                    return DELETE;
                }
                if (RowType.isInsert(row)) {
                    return INSERT;
                }
                if (RowType.isUpdate(row)) {
                    return UPDATE;
                }
            }
            return UNKNOWN;
        }

        public static boolean isValid(RowType rowType) {
            return supportedRowTypes.contains((Object)rowType);
        }

        public static boolean isDelete(Row row) {
            return row.deletion().time().markedForDeleteAt() > Long.MIN_VALUE;
        }

        public static boolean isInsert(Row row) {
            return row.primaryKeyLivenessInfo().timestamp() > Long.MIN_VALUE;
        }

        public static boolean isUpdate(Row row) {
            return row.primaryKeyLivenessInfo().timestamp() == Long.MIN_VALUE;
        }

        static {
            supportedRowTypes = new HashSet<RowType>(Arrays.asList(INSERT, UPDATE, DELETE, RANGE_TOMBSTONE));
        }
    }
}

