/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.File;
import jflex.Action;
import jflex.ErrorMessages;
import jflex.Macros;
import jflex.Out;
import jflex.RegExp;
import jflex.RegExp1;
import jflex.RegExp2;
import jflex.RegExps;

public final class SemCheck {
    private static Macros macros;

    public static void check(RegExps rs, Macros m, File f) {
        macros = m;
        int num = rs.getNum();
        for (int i = 0; i < num; ++i) {
            RegExp r = rs.getRegExp(i);
            RegExp l = rs.getLookAhead(i);
            Action a = rs.getAction(i);
            if (r == null || l == null || !SemCheck.maybeEmtpy(r)) continue;
            if (a == null) {
                Out.error(ErrorMessages.EMPTY_MATCH, "");
                continue;
            }
            Out.error(f, ErrorMessages.EMPTY_MATCH, a.priority - 1, -1);
        }
    }

    public static boolean maybeEmtpy(RegExp re) {
        switch (re.type) {
            case 44: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) || SemCheck.maybeEmtpy(r.r2);
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) && SemCheck.maybeEmtpy(r.r2);
            }
            case 42: 
            case 45: {
                return true;
            }
            case 43: {
                RegExp1 r1 = (RegExp1)re;
                return SemCheck.maybeEmtpy((RegExp)r1.content);
            }
            case 50: 
            case 55: 
            case 56: 
            case 59: {
                return false;
            }
            case 51: 
            case 58: {
                String content = (String)((RegExp1)re).content;
                return content.length() == 0;
            }
            case 49: {
                return false;
            }
            case 48: {
                RegExp1 r1 = (RegExp1)re;
                return !SemCheck.maybeEmtpy((RegExp)r1.content);
            }
            case 52: {
                return SemCheck.maybeEmtpy(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    public static int length(RegExp re) {
        switch (re.type) {
            case 44: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l1 == l2) {
                    return l1;
                }
                return -1;
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l2 < 0) {
                    return -1;
                }
                return l1 + l2;
            }
            case 42: 
            case 43: 
            case 45: {
                return -1;
            }
            case 50: 
            case 55: 
            case 56: 
            case 59: {
                return 1;
            }
            case 51: 
            case 58: {
                String content = (String)((RegExp1)re).content;
                return content.length();
            }
            case 48: 
            case 49: {
                return -1;
            }
            case 52: {
                return SemCheck.length(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    public static boolean isFiniteChoice(RegExp re) {
        switch (re.type) {
            case 44: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.isFiniteChoice(r.r1) && SemCheck.isFiniteChoice(r.r2);
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return false;
                }
                int l2 = SemCheck.length(r.r2);
                return l2 >= 0;
            }
            case 42: 
            case 43: 
            case 45: {
                return false;
            }
            case 50: 
            case 55: 
            case 56: 
            case 59: {
                return true;
            }
            case 51: 
            case 58: {
                return true;
            }
            case 48: 
            case 49: {
                return false;
            }
            case 52: {
                return SemCheck.isFiniteChoice(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }
}

