/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.debezium.connector.cassandra.AbstractCommitLogProcessorTest;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.TestUtils;
import java.util.List;
import org.junit.Assert;

public class ClusteringPartitionKeyCommitLogProcessingTest
extends AbstractCommitLogProcessorTest {
    @Override
    public void initialiseData() throws Exception {
        this.createTable("CREATE TABLE IF NOT EXISTS %s.%s (a int, b int, c int, PRIMARY KEY ((a), b)) WITH cdc = true;");
        TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)1)).value("c", (Term)QueryBuilder.literal((Object)1)).build());
        TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)2)).value("c", (Term)QueryBuilder.literal((Object)3)).build());
        TestUtils.runCql((SimpleStatement)((Delete)QueryBuilder.deleteFrom((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).whereColumn("a").isEqualTo((Term)QueryBuilder.literal((Object)1))).build());
    }

    @Override
    public void verifyEvents() throws Exception {
        List<Event> events = this.getEvents(3);
        Record insert1 = (Record)events.get(0);
        Assert.assertEquals((Object)insert1.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert1.getOp());
        Record insert2 = (Record)events.get(1);
        Assert.assertEquals((Object)insert2.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert2.getOp());
        Record delete = (Record)events.get(2);
        Assert.assertEquals((Object)delete.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.DELETE, (Object)delete.getOp());
    }
}

