/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.debezium.connector.cassandra.AbstractCommitLogProcessorTest;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.TestUtils;
import java.util.List;
import org.junit.Assert;

public class RangeTombstoneCommitLogProcessingTest
extends AbstractCommitLogProcessorTest {
    @Override
    public void initialiseData() throws Exception {
        this.createTable("CREATE TABLE IF NOT EXISTS %s.%s (a int, b int, c int, d int, e int, PRIMARY KEY (a,b,c,d)) WITH cdc = true;");
        TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)1)).value("c", (Term)QueryBuilder.literal((Object)1)).value("d", (Term)QueryBuilder.literal((Object)1)).value("e", (Term)QueryBuilder.literal((Object)1)).build());
        TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)1)).value("c", (Term)QueryBuilder.literal((Object)2)).value("d", (Term)QueryBuilder.literal((Object)3)).value("e", (Term)QueryBuilder.literal((Object)2)).build());
        TestUtils.runCql((SimpleStatement)((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).whereColumn("a").isEqualTo((Term)QueryBuilder.literal((Object)1))).whereColumn("b").isEqualTo((Term)QueryBuilder.literal((Object)1))).whereColumn("c").isLessThanOrEqualTo((Term)QueryBuilder.literal((Object)2))).build());
    }

    @Override
    public void verifyEvents() throws Exception {
        List<Event> events = this.getEvents(3);
        Assert.assertEquals((long)3L, (long)events.size());
        Record insert = (Record)events.get(0);
        Assert.assertEquals((Object)insert.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert.getOp());
        Record insert2 = (Record)events.get(1);
        Assert.assertEquals((Object)insert2.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert2.getOp());
        Record range1 = (Record)events.get(2);
        Assert.assertEquals((Object)range1.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.RANGE_TOMBSTONE, (Object)range1.getOp());
        Assert.assertEquals((Object)"INCL_START_BOUND(1)", (Object)range1.getRowData().getStart());
        Assert.assertEquals((Object)"INCL_END_BOUND(1, 2)", (Object)range1.getRowData().getEnd());
    }
}

