/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorTaskTemplate;
import io.debezium.connector.cassandra.CassandraOffsetContext;
import io.debezium.connector.cassandra.CassandraPartition;
import io.debezium.connector.cassandra.ComponentFactory;
import io.debezium.connector.cassandra.ComponentFactoryDebezium;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.spi.Offsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;

abstract class AbstractConnectorTask
extends BaseSourceTask<CassandraPartition, CassandraOffsetContext> {
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private CassandraConnectorTaskTemplate template;

    AbstractConnectorTask() {
    }

    public String version() {
        return Module.version();
    }

    protected ChangeEventSourceCoordinator<CassandraPartition, CassandraOffsetContext> start(Configuration config) {
        CassandraConnectorConfig connectorConfig = new CassandraConnectorConfig(config);
        if (connectorConfig.numOfChangeEventQueues() != 1) {
            throw new CassandraConnectorConfigException(String.format("configuration property %s must be equal to 1", CassandraConnectorConfig.NUM_OF_CHANGE_EVENT_QUEUES.name()));
        }
        connectorConfig.setValidationFieldList(Arrays.asList(CassandraConnectorConfig.CASSANDRA_NODE_ID, CassandraConnectorConfig.COMMIT_LOG_RELOCATION_DIR, CassandraConnectorConfig.SCHEMA_POLL_INTERVAL_MS, CassandraConnectorConfig.SNAPSHOT_POLL_INTERVAL_MS));
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.template.getTaskContext().configureLoggingContext(connectorConfig.getContextName())).build();
        CassandraOffsetContext.Loader offsetLoader = new CassandraOffsetContext.Loader();
        Offsets previousOffsets = this.getPreviousOffsets(new CassandraPartition.Provider(connectorConfig), offsetLoader);
        CassandraOffsetContext previousOffset = (CassandraOffsetContext)previousOffsets.getTheOnlyOffset();
        if (previousOffset == null) {
            previousOffset = offsetLoader.load((Map)new HashMap());
        }
        this.template = this.init(connectorConfig, new ComponentFactoryDebezium(this.queue, (CassandraPartition)previousOffsets.getTheOnlyPartition(), previousOffset));
        try {
            this.template.start();
        }
        catch (Exception e) {
            throw new CassandraConnectorTaskException(e);
        }
        return null;
    }

    protected abstract CassandraConnectorTaskTemplate init(CassandraConnectorConfig var1, ComponentFactory var2);

    protected List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected void doStop() {
        try {
            this.template.stopAll();
        }
        catch (Exception e) {
            throw new CassandraConnectorTaskException(e);
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return Collections.emptyList();
    }
}

