/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListenerBase;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SourceInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSchemaChangeListener
extends SchemaChangeListenerBase {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSchemaChangeListener.class);
    protected final String kafkaTopicPrefix;
    protected final SourceInfoStructMaker<SourceInfo> sourceInfoStructMaker;
    protected final SchemaHolder schemaHolder;

    public AbstractSchemaChangeListener(String kafkaTopicPrefix, SourceInfoStructMaker<SourceInfo> sourceInfoStructMaker, SchemaHolder schemaHolder) {
        this.kafkaTopicPrefix = kafkaTopicPrefix;
        this.sourceInfoStructMaker = sourceInfoStructMaker;
        this.schemaHolder = schemaHolder;
    }

    public List<TableMetadata> getCdcEnabledTableMetadataList(Session session) {
        return session.getMetadata().getKeyspaces().values().stream().flatMap(kmd -> kmd.getTables().values().stream()).filter(tm -> {
            if (tm.isVirtual()) {
                logger.info(String.format("Skipping virtual table %s.%s", tm.getKeyspace().asInternal(), tm.getName()));
                return false;
            }
            Object cdc = tm.getOptions().get(CqlIdentifier.fromCql((String)"cdc"));
            if (cdc == null) {
                logger.warn(String.format("There is no cdc option for table %s.%s. Available options are: %s", tm.getKeyspace().asInternal(), tm.getName(), tm.getOptions()));
                return false;
            }
            return cdc.toString().equals("true");
        }).collect(Collectors.toList());
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    protected KeyValueSchema getKeyValueSchema(TableMetadata tm) {
        return new KeyValueSchema.KeyValueSchemaBuilder().withTableMetadata(tm).withKafkaTopicPrefix(this.kafkaTopicPrefix).withPrimaryKeyNames(KeyValueSchema.getPrimaryKeyNames(tm)).withPrimaryKeySchemas(KeyValueSchema.getPrimaryKeySchemas(tm)).withSourceInfoStructMarker(this.sourceInfoStructMaker).withRowSchema(RowData.rowSchema(tm)).build();
    }
}

