/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.ChangeRecord;
import io.debezium.connector.cassandra.CommitLogUtil;
import io.debezium.connector.cassandra.EOFEvent;
import io.debezium.connector.cassandra.Emitter;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.KafkaRecordEmitter;
import io.debezium.connector.cassandra.TombstoneRecord;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueProcessor.class);
    private final ChangeEventQueue<Event> queue;
    private final Emitter kafkaRecordEmitter;
    private final String commitLogRelocationDir;
    private final Set<String> erroneousCommitLogs;
    private static final String NAME_PREFIX = "Queue Processor ";
    public static final String ARCHIVE_FOLDER = "archive";
    public static final String ERROR_FOLDER = "error";

    public QueueProcessor(CassandraConnectorContext context, int index) {
        super("Queue Processor [" + index + "]", Duration.ZERO);
        this.queue = context.getQueues().get(index);
        this.erroneousCommitLogs = context.getErroneousCommitLogs();
        this.commitLogRelocationDir = context.getCassandraConnectorConfig().commitLogRelocationDir();
        this.kafkaRecordEmitter = new KafkaRecordEmitter(context.getCassandraConnectorConfig(), context.getKafkaProducer(), context.getOffsetWriter(), context.getCassandraConnectorConfig().offsetFlushIntervalMs(), context.getCassandraConnectorConfig().maxOffsetFlushSize(), context.getCassandraConnectorConfig().getKeyConverter(), context.getCassandraConnectorConfig().getValueConverter(), context.getErroneousCommitLogs(), context.getCassandraConnectorConfig().getCommitLogTransfer());
    }

    @VisibleForTesting
    public QueueProcessor(CassandraConnectorContext context, int index, Emitter emitter) {
        super("Queue Processor [" + index + "]", Duration.ZERO);
        this.queue = context.getQueues().get(index);
        this.kafkaRecordEmitter = emitter;
        this.erroneousCommitLogs = context.getErroneousCommitLogs();
        this.commitLogRelocationDir = context.getCassandraConnectorConfig().commitLogRelocationDir();
    }

    @Override
    public void process() throws InterruptedException {
        List events = this.queue.poll();
        for (Event event : events) {
            try {
                this.processEvent(event);
            }
            catch (Exception ex) {
                LOGGER.error("Processing of event {} was errorneous: {}", (Object)event, (Object)ex);
            }
        }
    }

    @Override
    public void initialize() throws Exception {
        File dir = new File(this.commitLogRelocationDir);
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Failed to create " + this.commitLogRelocationDir);
        }
        File archiveDir = new File(dir, ARCHIVE_FOLDER);
        if (!archiveDir.exists() && !archiveDir.mkdir()) {
            throw new IOException("Failed to create " + archiveDir);
        }
        File errorDir = new File(dir, ERROR_FOLDER);
        if (!errorDir.exists() && !errorDir.mkdir()) {
            throw new IOException("Failed to create " + errorDir);
        }
    }

    @Override
    public void destroy() throws Exception {
        this.kafkaRecordEmitter.close();
    }

    private void processEvent(Event event) {
        if (event == null) {
            return;
        }
        switch (event.getEventType()) {
            case CHANGE_EVENT: {
                ChangeRecord changeRecord = (ChangeRecord)event;
                this.kafkaRecordEmitter.emit(changeRecord);
                break;
            }
            case TOMBSTONE_EVENT: {
                TombstoneRecord tombstoneRecord = (TombstoneRecord)event;
                this.kafkaRecordEmitter.emit(tombstoneRecord);
                break;
            }
            case EOF_EVENT: {
                EOFEvent eofEvent = (EOFEvent)event;
                Path commitLog = Paths.get(eofEvent.file.getAbsolutePath(), new String[0]);
                String commitLogFileName = commitLog.getFileName().toString();
                LOGGER.info("Encountered EOF event for {} ...", (Object)commitLogFileName);
                String folder = this.erroneousCommitLogs.contains(commitLogFileName) ? ERROR_FOLDER : ARCHIVE_FOLDER;
                Path relocationDir = Paths.get(this.commitLogRelocationDir, folder);
                CommitLogUtil.moveCommitLog(commitLog, relocationDir);
                break;
            }
            default: {
                LOGGER.warn("Encountered unexpected record with type: {}", (Object)event.getEventType());
            }
        }
    }
}

